---
description: Rekonfigurace agenta — změní rules, skills a workflows podle nové domény/potřeb uživatele
---

# /mind Workflow

**Metanástroj pro totální rekonfiguraci agenta.**

Transformuje celou konfiguraci (`.agent/rules/`, `.agent/skills/`, `.agent/workflows/`) na novou doménu při zachování struktury a stylu interakce.

> [!CAUTION]
> **DESTRUKTIVNÍ OPERACE!** Přepíše existující konfiguraci.
> Vyžaduje explicitní schválení uživatelem.

---

## Postup

### 1. UVÍTEJ uživatele

**Bez parametru** (`/mind`) — zobraz plné uvítání:

1. Vytvoř **originální ASCII art banner** — stylizovaný text "MIND" nebo symbol metamorfózy
2. Použij box-drawing znaky (`╔═╗║╚╝`) pro rámeček
3. Buď kreativní — každé volání může mít unikátní design

> *Ahoj! Jsem tvůj agent a umím se proměnit v cokoliv.*
> 
> Právník, kreativní spisovatel, business stratég, výzkumník...
> **Řekni mi, čím se mám stát.**

Poté spusť **Interaktivní Discovery Dialog** (sekce níže).

---

**S parametrem** (`/mind [doména]`) — rychlé potvrzení:

> 🔄 **Transformace:** *[zadaná doména]*
> 
> Připravuji rekonfiguraci...

Přeskoč dialog a pokračuj krokem **2. ANALYZUJ aktuální stav**.

---

### 2. ZJISTI cílovou doménu

```
IF uživatel zadal parametr:
    Použij zadanou doménu → pokračuj na krok 3
ELSE:
    Spusť INTERAKTIVNÍ DISCOVERY DIALOG (viz sekce níže)
```

---

## Interaktivní Discovery Dialog

Když uživatel zavolá `/mind` bez parametru, veď **víceúrovňový A/B/C dialog**:

### Pravidla dialogu

1. **Vždy nabízej 3-5 konkrétních možností** + escape varianty
2. **Kontextově přizpůsobuj** — návrhy závisí na předchozích odpovědích
3. **Postupně zužuj** — od obecného ke specifickému
4. **Čekej na odpověď** — nikdy nepokračuj bez volby uživatele

---

### Formát otázky

**[Otázka v přirozeném jazyce]**

| | |
|---|---|
| **A)** | 🔬 Možnost první |
| **B)** | ✍️ Možnost druhá |
| **C)** | 💼 Možnost třetí |
| ─── | ─────────────── |
| **D)** | Další návrhy... |
| **E)** | ✏️ Vlastní odpověď |

---

### Příklad průběhu

#### Úroveň 1 — Oblast

**Na jakou oblast se chceš zaměřit?**

| | |
|---|---|
| **A)** | 🔬 Výzkum / Analýza |
| **B)** | ✍️ Kreativní psaní |
| **C)** | 💼 Business / Strategie |
| **D)** | 🎓 Vzdělávání / Mentoring |
| ─── | ─────────────── |
| **E)** | Další návrhy... |
| **F)** | ✏️ Vlastní odpověď |

---

#### Úroveň 2 — Specifikace *(po volbě A)*

**Jaký typ výzkumu?**

| | |
|---|---|
| **A)** | 🔧 Technologický *(API, frameworky, nástroje)* |
| **B)** | 📚 Akademický *(studie, rešerše, citace)* |
| **C)** | 📊 Tržní *(konkurence, trendy, analýzy)* |
| **D)** | ⚖️ Právní *(legislativa, smlouvy, compliance)* |
| ─── | ─────────────── |
| **E)** | Další návrhy... |
| **F)** | ✏️ Vlastní odpověď |

---

#### Úroveň 3 — Styl *(po volbě B)*

**Jaký má být styl výstupů?**

| | |
|---|---|
| **A)** | 📝 Formální akademický *(citace, struktura)* |
| **B)** | 💡 Stručné shrnutí *(bullet points)* |
| **C)** | 🎯 Akční doporučení *(co dělat)* |
| ─── | ─────────────── |
| **D)** | Další návrhy... |
| **E)** | ✏️ Vlastní odpověď |

---

#### Finální potvrzení

**Rozumím správně?**

| Parametr | Hodnota |
|----------|---------|
| **Role** | Akademický výzkumník |
| **Styl** | Formální s citacemi |
| **Výstupy** | Strukturované rešerše |

> Souhlasíš? *(ano / upravit / zrušit)*

---

### 2. ANALYZUJ aktuální stav

Prozkoumej a zdokumentuj:

| Složka | Obsah | Počet |
|--------|-------|-------|
| `.agent/rules/` | Pravidla chování | X souborů |
| `.agent/skills/` | Dovednosti | X složek |
| `.agent/workflows/` | Slash commands | X souborů |

### 3. NAVRHNI mapování

**Workflows (zachovat commands):**

| Původní | Nový účel |
|---------|-----------|
| `/analyze` | [nový účel] |
| `/audit` | [nový účel] |
| `/brainstorm` | [nový účel] |
| `/do` | ✅ Beze změny |
| `/explain` | ✅ Beze změny |
| `/fix` | [nový účel] |
| `/research` | [nový účel] |
| `/feature` | [nový účel] |
| `/issue` | [nový účel] |
| `/debug` | [nový účel nebo odstranit] |

**Rules (přizpůsobit):**

| Původní | Nové |
|---------|------|
| `czech-communication.md` | ✅ Zachovat |
| `web-dev-standards.md` | → `[domain]-standards.md` |
| `no-browser-testing.md` | → `[domain]-restrictions.md` |

**Skills (transformovat):**

| Původní | Nový ekvivalent |
|---------|-----------------|
| `tech-researcher` | `[domain]-researcher` |
| `refactorer` | `[domain]-optimizer` |
| ... | ... |

### 4. PŘEDLOŽ plán ke schválení

```markdown
# Transformace: [Původní] → [Nová doména]

## Zachované (bez změny)
- `/do`, `/explain`
- `czech-communication.md`

## Transformované
[seznam změn]

## Odstraněné
[seznam irelevantních]

## Nové
[seznam nových pro doménu]
```

### 5. ČEKEJ na schválení

> [!IMPORTANT]
> **STOP! Bez explicitního schválení NEPOKRAČUJ:**
> - "ano" / "ok" / "pokračuj" → proveď transformaci
> - Úpravy → uprav plán a zeptej se znovu
> - "ne" → zruš operaci

### 6. PROVEĎ transformaci

// turbo-all

Po schválení:

1. **Zálohuj** aktuální stav do `.agent/backup/YYYY-MM-DD/`
2. **Přepiš** rules podle mapování
3. **Přepiš** skills podle mapování
4. **Přepiš** workflows podle mapování
5. **Ověř** konzistenci (žádné chybějící reference)

### 7. SHRŇ výsledek

```markdown
# Transformace dokončena

**Původní:** [X] → **Nová:** [Y]

## Změny
- Workflows: X upraveno
- Rules: X upraveno
- Skills: X upraveno

## Dostupné commands
[seznam s popisem]
```

---

## Příklady transformací

### Webový vývoj → Právní analýza

| Původní | Nový |
|---------|------|
| `/debug` → `/review` | Revize smlouvy |
| `/fix` → `/correct` | Oprava právních vad |
| `web-dev-standards` → `legal-standards` | Právní náležitosti |
| `tech-researcher` → `legal-researcher` | Právní výzkum |

### Webový vývoj → Konverzační agent

| Původní | Nový |
|---------|------|
| `/debug` → `/reflect` | Reflexe nad myšlenkami |
| `/fix` → `/revise` | Revize závěrů |
| `web-dev-standards` → `thinking-standards` | Strukturované myšlení |
| `tech-researcher` → `topic-researcher` | Výzkum témat |

---

## Kontrolní seznam

> [!IMPORTANT]
> **PŘED PROVEDENÍM:**
> - [ ] Discovery dialog dokončen NEBO parametr zadán
> - [ ] Cílová doména je jasně definovaná
> - [ ] Mapování pokrývá všechny stávající soubory
> - [ ] Uživatel explicitně schválil plán
> - [ ] Univerzální commands (`/do`, `/explain`) zůstávají

> [!CAUTION]
> **PO PROVEDENÍ:**
> - [ ] Záloha vytvořena v `.agent/backup/`
> - [ ] Všechny soubory jsou validní markdown
> - [ ] Žádné chybějící reference mezi soubory
> - [ ] Agent reaguje správně na slash commands
