---
description: Interaktivní testování a výběr SVG ikon s PHP backendem
---

# /icon-test

Spustí interaktivní session pro generování a výběr SVG ikon.

## Syntaxe
```
/icon-test [název ikony] [popis]
```

Příklad: `/icon-test plíce ikona pro dechovou frekvenci`

## Postup

### 1. Spuštění session
- Vytvoř/aktualizuj `icon-test/session.json` s požadavkem
- Vygeneruj 10+ variant SVG ikon do `icon-test/variants/`
- Aktualizuj PHP stránku pro zobrazení variant

### 2. Uživatel vybírá na webu
- Otevře `icon-test/index.php`
- Kliká na ikony (líbí se / další návrhy)
- PHP ukládá výběr do `session.json`

### 3. Uživatel se vrací k agentovi
Stačí napsat cokoliv:
- "hotovo", "vybral jsem", "dál", číslo...
- Agent přečte `session.json`
- Nabídne číslované akce:
  1. Použít vybranou ikonu → uloží do `assets/icons/`
  2. Generovat další varianty od vybraných
  3. Zahodit a začít znovu

### 4. Cyklus pokračuje
Opakuj kroky 2-3 dokud není uživatel spokojený.

## Struktura `/icon-test/`
```
icon-test/
├── index.php      # UI s variantami
├── api.php        # AJAX endpoint pro ukládání
├── session.json   # Stav session
├── styles.css     # Styly
└── variants/      # SVG soubory
```

## Čtení session.json
Agent MUSÍ přečíst `icon-test/session.json` když uživatel napíše:
- "hotovo", "vybral", "check", "další", číslo, nebo cokoliv po návštěvě webu

## Ukončení
Po finálním výběru:
1. Zkopíruj vybranou SVG do `assets/icons/[název].svg`
2. Přidej do seznamu ikon v `js/main.js` (pokud chybí)
3. Označ session jako dokončenou
