---
description: Analyzuj problém a navrhni řešení — hloubková analýza bez implementace
---

# /analyze

Syntaxe: viz `workflow-syntax.md` — scope: komponenta/popis/screenshot, `/do` = analýza + implementace

## Účel
Hloubková analýza problému:
1. Pochop problém z kontextu dialogu nebo screenshotu
2. Prozkoumej relevantní části kódu
3. Identifikuj příčiny a rizika
4. Navrhni řešení seřazená dle efektivity
5. Bez `/do`: ČEKEJ na uživatele

## Zdroje
- Aktuální dialog (primární zdroj problému)
- Screenshot (vizuální reference — "toto nefunguje jak má")
- `.agent/rules/` — pravidla projektu
- `.agent/skills/` — best practices
- Codebase — architektura

## Screenshot jako vstup
Pokud uživatel poskytne screenshot:
- Analyzuj jako **iPhone PWA** v standalone režimu
- Porovnej s aktuální implementací
- Identifikuj rozdíly (co nefunguje vs. jak má vypadat)
- Buď PRECIZNÍ v detailech

NEPROCHÁZEJ `docs/` — šetři tokeny.

## Kroky

### 1. Pochop problém
- Dialog → použij kontext
- Screenshot → analyzuj vizuál + porovnej s kódem
- Nic → zeptej se uživatele

### 2. Prozkoumej kontext
- Načti relevantní pravidla
- Prostuduj relevantní skills
- Identifikuj dotčené soubory

### 3. Identifikuj příčiny
Pro každou příčinu:
- Co způsobuje problém
- Kde v kódu (soubory/funkce)
- Proč to vzniklo

### 4. Vyhodnoť rizika
- 🔴 VYSOKÉ — může rozbít jinou funkcionalitu
- 🟡 STŘEDNÍ — vyžaduje pečlivé testování
- 🟢 NÍZKÉ — izolovaná změna

### 5. Navrhni řešení
Seřaď dle efektivity (přínos/náročnost):
- Přístup, dotčené soubory, riziko, náročnost

### 6. Předlož analýzu
Struktura: Problém → Příčiny → Rizika → Návrhy → Doporučení

### 7. Bez `/do`: ČEKEJ na uživatele
Čekej na: schválení, výběr varianty, další otázky, nebo `/do`

## Kombinace
- `/analyze` — pouze analýza
- `/analyze /do` — analýza + implementace
- `/analyze /fix` — analýza + oprava dle auditu
