---
name: kodi-image-generator
description: Generování konzistentních obrázků/ikon pro Kodi UI. Použij když uživatel chce vygenerovat grafiku pro addon (ikony, karty, bannery). NEPOUŽÍVEJ pro programatické vytváření masek/textur v Python kódu.
trigger: generate_image, create_icon, card_graphics, button_texture, banner_design, kodi_artwork
---

# Kodi Image Generator Skill

## Kdy použít
- Uživatel chce **vygenerovat obrázky/ikony** pro Kodi UI (karty, tlačítka, bannery)
- Výstup půjde do `resources/media/` nebo XML textury

## Kdy NEPOUŽÍVAT
- Vytváření masek/textur pomocí PIL v Python kódu
- Úpravy existujících obrázků bez generování nových

---

## Workflow

### 1. Analýza cíle
1. Zjisti **cílové rozměry** z XML (`<width>`, `<height>`)
2. Vypočítej **cílový poměr stran** (např. 340x200 = 1.7)
3. Generátor vrací **1024x1024** (1:1) - vždy!

### 2. Diskuze o stylu
**NIKDY negeneruj hromadně!**

1. **Zeptej se** na požadovaný vizuální styl (Netflix, Apple TV, Flat, Neon...)
2. **Počkej na odpověď** a upřesni detaily
3. Teprve pak pokračuj

### 3. Master Image
1. Vygeneruj **POUZE JEDEN** obrázek (master)
2. **Ukaž uživateli** a čekej na schválení
3. Pokud neschváleno → uprav prompt a opakuj
4. **Prompt tipy:**
   - Obsah musí být **vycentrovaný** (nahoře/dole bude ořez)
   - Styl: flat 2D, žádné 3D efekty
   - Pozadí: tmavé, jednotné

### 4. Generování dalších obrázků
Po schválení master image:

1. Generuj **PO JEDNOM** (ne paralelně!)
2. **POVINNĚ předej master obrázek jako `ImagePaths` parametr:**
   ```
   generate_image(
       ImagePaths=["/path/to/master_image.png"],
       Prompt="SAME STYLE AS INPUT IMAGE, ..."
   )
   ```
3. V promptu **VŽDY** uveď: `"SAME STYLE AS INPUT IMAGE"`
4. Měň pouze motiv, styl se přenese z master reference
5. Po každém obrázku čekej na schválení

### 5. Ořez na cílový formát
**KRITICKÉ:** Generátor vrací 1:1 (1024x1024). Musíš oříznout, NE resizovat!

**Výpočet výšky ořezu:**
```
target_height = 1024 * (cílová_výška / cílová_šířka)
```
Příklad pro 340x200:
```
1024 * (200 / 340) = 602px
```

**Příkaz pro ořez (macOS):**
```bash
sips -c [výška] [šířka] input.png -o output.png
```
Příklad:
```bash
sips -c 602 1024 master.png -o card.png
```

**Co to udělá:**
- Zachová **plnou šířku** (1024px)
- Ořízne **symetricky nahoře a dole** na 602px
- Kvalita zůstane **100%** (žádný downscale)
- Kodi pak sám zmenší na cílový rozměr (340x200)

### 6. Nasazení
```bash
cp card_*.png "resources/media/"
```

XML reference:
```xml
<texturefocus>special://home/addons/[addon]/resources/media/card_name.png</texturefocus>
```

---

## Shrnutí flow
```
ANALÝZA → DISKUZE STYLU → MASTER (1x) → SCHVÁLENÍ → 
DALŠÍ (1 po 1 s masterem jako ref) → OŘEZ (sips -c) → NASAZENÍ
```

## Časté chyby
| Chyba | Správně |
|-------|---------|
| `sips -z` (resize) | `sips -c` (crop) |
| Generovat vše najednou | Po jednom, s masterem jako ref |
| Prompt bez "centered" | Vždy centered kompozice |
| Resize na malé px | Crop na formát, kvalita zůstane |
