# Milionář – Prompty pro typ Režisér (kopírovatelné do kódu)

Níže jsou finální, samostatné prompty pro typ hry Režisér. Každý prompt je nezávislý inference call, respektuje globální obtížnost `{difficulty_header}` a má jednotný JSON výstup. Bloky lze přímo vložit do funkcí v `wcs/ai_handler.py`.

---

## SNADNÁ (Režisér)

```python
prompt = f"""{difficulty_header}Jsi expert na filmové kvízy. Vytvoř přesně 3 SNADNÉ otázky pro kvíz typu "Chcete být milionářem" o režisérovi {director_name}.{bio_info}{films_info}

OBTÍŽNOST: SNADNÁ - "Základní znalosti kariéry"
TÉMATA: Narození, nejslavnější filmy, základní ocenění, kariérní fakta
CÍLOVÁ SKUPINA: Každý fanoušek filmů pozná

PŘÍKLADY TÉMAT:
- Kdy se režisér narodil?
- Jaký je jeho nejslavnější film?
- Za jaký film získal Oscar?
- V jakém roce debutoval?
- Jaké je jeho rodné město?
- Který film ho proslavil?
- Jaké má základní vzdělání?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být JEDNODUCHÉ pro běžného fanouška
- Zaměř se POUZE na základní fakta a nejslavnější díla
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```

---

## STŘEDNÍ (Režisér)

```python
prompt = f"""{difficulty_header}Jsi expert na filmové kvízy. Vytvoř přesně 3 STŘEDNÍ otázky pro kvíz typu "Chcete být milionářem" o režisérovi {director_name}.{bio_info}{films_info}

OBTÍŽNOST: STŘEDNÍ - "Pozornost k detailům kariéry"
TÉMATA: Konkrétní filmy, spolupráce s herci, technika natáčení, méně známá díla
CÍLOVÁ SKUPINA: Pozorný fanoušek si všimne

PŘÍKLADY TÉMAT:
- Jakou techniku použil v [konkrétním filmu]?
- S jakým hercem spolupracoval nejčastěji?
- Jaký je jeho charakteristický styl?
- V kterém roce natočil [film]?
- Jaké má vzdělání v režii?
- S jakým kameramanem spolupracoval?
- Jaký žánr preferuje?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být STŘEDNÍ obtížnosti
- Zaměř se na DETAILY kariéry a spolupráce
- Vyžadují lepší znalost režiséra, ne jen základní fakta
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```

---

## TĚŽKÁ (Režisér)

```python
prompt = f"""{difficulty_header}Jsi filmový historik. Vytvoř přesně 3 TĚŽKÉ otázky pro kvíz typu "Chcete být milionářem" o režisérovi {director_name}.{bio_info}{films_info}

OBTÍŽNOST: TĚŽKÁ - "Režisérská erudice"
TÉMATA: Detailní trivia, specifická ocenění, méně známé projekty, historické souvislosti
CÍLOVÁ SKUPINA: Skutečný znalec režiséra pozná

PŘÍKLADY TÉMAT:
- Za jaký film byl nominován na [konkrétní rok]?
- V kterém divadle režíroval?
- Jaké má konkrétní ocenění z [festival]?
- V jakém roce debutoval v televizi?
- Jaké má vzdělání v režii?
- Který méně známý film produkoval?
- Jaké má konkrétní hobby nebo zájmy?
- V kterém roce získal [konkrétní cenu]?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být TĚŽKÉ - pro skutečné znalce
- Zaměř se na DETAILNÍ TRIVIA a méně známé fakta
- Kombinace znalosti režiséra + filmové kultury
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```