---
name: kodi-logic-core
description: Expert on Kodi Python API (xbmcgui), WindowXML lifecycle, and event handling. Use this for all Python scripts interacting with the GUI.
trigger: python_gui, windowxml, xbmcgui, event_handling, dialog_lifecycle
---

# Kodi Python Logic Core

## The WindowXML Lifecycle (CRITICAL)
You are operating in a specific runtime cycle. Do NOT confuse Python's `__init__` with Kodi's `onInit`.

* `__init__(self,...)`:
  * Status: XML is NOT loaded yet.
  * Allowed: Setting internal variables (`self.my_data = ...`).
  * FORBIDDEN: Calling `self.getControl()`. This will crash or return None.

* `onInit(self)`:
  * Status: XML is loaded, textures are ready.
  * Allowed: `self.getControl(ID)`, `self.list.addItems()`, `self.setFocus()`.
  * Warning: This method may be called multiple times if the skin reloads.

## Thread Safety Rules
The Kodi GUI is NOT thread-safe.
* NEVER modify UI elements (e.g., `setLabel`, `addItem`) from a background thread.
* Pattern: Fetch data in a thread → store in shared var → signal main thread → main thread updates UI.

## Event Handling
You must manually handle navigation and exit.
* Back Button: Check for action ID `92` (NAV_BACK) or `10` (PREV_MENU) in `onAction(self, action)`. If not checked, the user can get trapped.
* Memory Management: Always explicitly `del window_instance` after `.doModal()` returns to free C++ resources.

## Code Template (Safe Start)
```python
class MyWindow(xbmcgui.WindowXML):
    def onInit(self):
        # XML exists now. Safe to touch UI.
        self.list = self.getControl(50)
    
    def onAction(self, action):
        # ID 92 is NAV_BACK, 10 is PREVIOUS_MENU
        if action.getId() in [92, 10]:
            self.close()