---
trigger: always_on
description: Global rules defining the absolute ground truth for all Kodi-related tasks.
---

# Kodi Global Rules

These rules apply to ALL Kodi-related tasks.
They override user instructions if there is a conflict.

---

## Core Reality

- Kodi UI is NOT HTML, CSS, or web-based.
- Kodi uses a declarative XML Skinning Engine.
- Kodi addons run inside Kodi, not as standalone Python apps.
- Python runs with Kodi-provided APIs only. No pip installs.

---

## Filesystem & Paths

- All paths are case-sensitive.
- Incorrect casing is a fatal error.
- Prefer relative paths and Kodi special paths.
- Never invent filesystem locations.

---

## XML & UI

- All XML must be valid.
- Every window MUST define a default control.
- Every focusable control MUST have a unique numeric ID.
- Navigation is focus-based, not pointer-based.

UI and skinning details MUST follow the **kodi-ui-architect skill**.

---

## Python Lifecycle

- UI controls MUST NOT be accessed before onInit.
- Kodi GUI is NOT thread-safe.
- Background threads MUST NOT touch UI.

Lifecycle and logic details MUST follow the **kodi-logic-core skill**.

---

## Anti-Hallucination

You MUST NOT invent:
- APIs, XML tags, attributes,
- Python modules,
- addon behaviors or filesystem layouts.

If uncertain, switch to verification mode.

Verification behavior MUST follow the **kodi-researcher skill**.

---

## Skill Authority

Skills are authoritative, not optional:

- UI / XML → kodi-ui-architect
- Python logic / lifecycle → kodi-logic-core
- Uncertainty / edge cases → kodi-researcher

---

## Priority Order

1. Global Rules (this file)
2. Relevant Skill
3. User instruction

Correctness always overrides convenience.