#!/usr/bin/env python3
"""Generate high-quality pill-shaped button texture for Kodi action buttons."""
from PIL import Image, ImageDraw

# Dimensions matching the button size in XML (200x45)
WIDTH = 200
HEIGHT = 45
RADIUS = HEIGHT // 2  # Perfect pill shape

# Create image with transparency
img = Image.new('RGBA', (WIDTH, HEIGHT), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Draw perfect white pill shape (fully opaque white - colordiffuse will tint it)
draw.rounded_rectangle(
    [(0, 0), (WIDTH - 1, HEIGHT - 1)],
    radius=RADIUS,
    fill=(255, 255, 255, 255)
)

# Save
output_path = '/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/btn_pill.png'
img.save(output_path, 'PNG')
print(f"Created: {output_path}")
print(f"Size: {WIDTH}x{HEIGHT}px, Radius: {RADIUS}px (pill shape)")
