# Refaktoring struktury XML souborů

**Stav: HOTOVO** ✅

Tento dokument popisuje dokončený refaktoring struktury XML souborů skinu. Cílem bylo reorganizovat soubory do logických doménových složek pro lepší přehlednost a udržovatelnost.

## Finální struktura

Níže je finální stromová struktura adresáře `resources/skins/Default/1080i/`. Všechny soubory byly přesunuty do tematických složek.

```
resources/skins/Default/1080i/
├─ ai/
│  └─ DialogAIDebugRequest.xml
├─ details_extras/
│  ├─ DialogActorDetails.xml
│  ├─ DialogCollectionDetails.xml
│  ├─ DialogDirectorDetails.xml
│  ├─ DialogSimilarMovies.xml
│  ├─ DialogWcsDetails.xml
│  └─ DialogWcsMyList.xml
├─ games/
│  ├─ DialogShowCorrectAnswer.xml
│  └─ DialogWcsTextGame.xml
├─ guide/
│  ├─ DialogAIGuide.xml
│  ├─ DialogLibraryGuide.xml
│  ├─ DialogRemoteGuide.xml
│  ├─ DialogTMDbGuide.xml
│  └─ DialogWebshareGuide.xml
├─ login/
│  ├─ DialogAILogin.xml
│  ├─ DialogLibraryFolder.xml
│  ├─ DialogTMDbLogin.xml
│  └─ DialogWebshareLogin.xml
├─ notifications/
│  ├─ classic/
│  │  ├─ DialogAutoplayCountdown.xml
│  │  ├─ DialogEpisodeInfoWithGame.xml
│  │  └─ DialogMovieInfoWithGame.xml
│  ├─ minimal/
│  │  ├─ DialogAutoplayCountdown.xml
│  │  ├─ DialogEpisodeInfoWithGame.xml
│  │  └─ DialogMovieInfoWithGame.xml
│  └─ modern/
│     ├─ DialogAutoplayCountdown.xml
│     ├─ DialogEpisodeInfoWithGame.xml
│     └─ DialogMovieInfoWithGame.xml
├─ search/
│  └─ DialogWcsSearch.xml
```

## Shrnutí provedených změn

Všechny soubory skinu byly úspěšně přesunuty do nových doménových složek. Názvy souborů byly sjednoceny, aby odpovídaly konvencím projektu. Veškeré cesty v `<include file="...">` a v Python kódu, které na tyto soubory odkazovaly, byly aktualizovány.

**Logické rozdělení do složek:**

-   **ai/**: Dialog pro ladění AI.
-   **details_extras/**: Dialogy zobrazující doplňkové detaily (herci, kolekce, režiséři, podobné filmy, můj seznam atd.).
-   **games/**: Dialogy související s hrami.
-   **guide/**: Dialogy s uživatelskými návody pro různé části doplňku.
-   **login/**: Všechny přihlašovací dialogy (TMDb, Webshare, AI, Knihovna).
-   **notifications/**: Dialogy pro notifikace a informace o přehrávání, rozdělené podle vizuálního stylu na `classic`, `minimal` a `modern`.
-   **search/**: Dialog pro vyhledávání.

Tímto je refaktoring struktury XML souborů kompletně dokončen.