# Refaktoring struktury Python souborů

**Stav: HOTOVO** ✅

Tento dokument popisuje dokončený refaktoring struktury Python souborů v projektu. Cílem bylo reorganizovat soubory do logických doménových složek pro lepší přehlednost a udržovatelnost.

## Finální struktura

Níže je finální stromová struktura adresáře `wcs/`. Klíčové soubory `router.py`, `utils.py`, `localization.py` a `user_data.py` byly záměrně ponechány v kořenovém adresáři `wcs/` pro snazší přístup, protože představují jádro doplňku.

```
plugin.video.milionar/
└─ wcs/
   ├─ router.py
   ├─ utils.py
   ├─ localization.py
   ├─ user_data.py
   ├─ ui/
   │  ├─ dialogs/
   │  │  ├─ DialogWcsSearch.py
   │  │  ├─ DialogWcsMyList.py
   │  │  └─ DialogWcsDetails.py
   │  ├─ ContextMenu.py
   │  └─ UI.py
   ├─ playback/
   │  ├─ DialogAutoplayCountdown.py
   │  ├─ DialogMovieInfoWithGame.py
   │  ├─ DialogEpisodeInfoWithGame.py
   │  └─ PlayerMonitor.py
   ├─ metadata/
   │  ├─ TMDbClient.py
   │  ├─ TMDbCache.py
   │  └─ CSFDClient.py
   ├─ login/
   │  ├─ DialogTMDbLogin.py
   │  ├─ DialogWebshareLogin.py
   │  ├─ DialogLibraryFolder.py
   │  └─ DialogAILogin.py
   ├─ search/
   │  ├─ MovieSearch.py
   │  └─ SeriesSearch.py
   ├─ webshare/
   │  ├─ WebshareClient.py
   │  └─ DownloadManager.py
   ├─ games/
   │  ├─ GameManager.py
   │  ├─ MillionaireGame.py
   │  ├─ QuizGame.py
   │  ├─ AdventureGame.py
   │  ├─ DialogWcsTextGame.py
   │  └─ DialogShowCorrectAnswer.py
   ├─ library/
   │  └─ LibraryManager.py
   ├─ ai/
   │  ├─ AIProvider.py
   │  ├─ AIHandler.py
   │  ├─ UsageTracker.py
   │  ├─ UsageUI.py
   │  ├─ OpenAIClient.py
   │  ├─ MistralClient.py
   │  ├─ AnthropicClient.py
   │  ├─ GoogleClient.py
   │  ├─ TTSClient.py
   │  └─ DialogAIDebugRequest.py

```

## Logické rozdělení do složek

Všechny moduly byly úspěšně přesunuty do nových doménových složek. Veškeré importy v rámci celého projektu byly aktualizovány, aby odpovídaly nové struktuře.

-   **ai/**: Zpracovává veškerou komunikaci s AI providery (OpenAI, Anthropic, atd.), včetně generování textu a TTS.
-   **games/**: Obsahuje logiku pro všechny hry v doplňku, jako je Milionář a textové adventury.
-   **library/**: Stará se o správu a interakce s knihovnou Kodi.
-   **login/**: Sjednocuje všechny dialogy a logiku pro přihlašování k externím službám (TMDb, Webshare, AI).
-   **metadata/**: Zajišťuje komunikaci s externími databázemi jako TMDb a ČSFD pro získávání detailů o filmech a seriálech.
-   **playback/**: Řídí logiku spojenou s přehráváním, včetně monitorování přehrávače a funkce autoplay.
-   **search/**: Obsahuje logiku pro vyhledávání filmů a seriálů.
-   **ui/**: Zodpovídá za prezentační vrstvu, generování UI prvků a správu dialogů.
-   **webshare/**: Zajišťuje kompletní komunikaci s Webshare, včetně přihlášení, vyhledávání a stahování.

Tímto je refaktoring struktury Python souborů kompletně dokončen.
