## Refaktoring routeru (`wcs/router.py`)

### Smysl
- **Cíl**: `wcs/router.py` má být čistý směrovač akcí; UI dialogy a síťová/doménová logika patří do samostatných modulů.
- **Přínos**: vyšší čitelnost, modularita, snadnější údržba a opakované použití.

### Postup
- Refaktorujeme vždy pouze jednu konkrétní položku. Každý krok provedu až po tvém explicitním schválení; po tvém otestování a potvrzení položku označíme jako hotovou a teprve pak přejdeme na další.
- Vyčlenit všechny `WindowXMLDialog` třídy z `wcs/router.py` do `wcs/ui/dialogs/**`.
- V routeru ponechat jen větve `action` → volání odpovídající třídy/funkce.
- Přímé požadavky na TMDb řešit přes `wcs/metadata/TMDbClient.py`.
- Sjednotit a odstranit duplicity „Guide“ dialogů.

### Rozsah přesunů (cílové umístění)
- `SimilarMoviesDialog` → `wcs/ui/dialogs/DialogSimilarMovies.py` (XML: `details_extras/DialogSimilarMovies.xml`)
- `SimilarSeriesDialog` → `wcs/ui/dialogs/DialogSimilarSeries.py` (XML: `details_extras/DialogSimilarMovies.xml`)
- `CollectionDialog` → `wcs/ui/dialogs/DialogCollectionDetails.py` (XML: `details_extras/DialogCollectionDetails.xml`)
- `DirectorDialog` → `wcs/ui/dialogs/DialogDirectorDetails.py` (XML: `details_extras/DialogDirectorDetails.xml`)
- `ActorDialog` → `wcs/ui/dialogs/DialogActorDetails.py` (XML: `details_extras/DialogActorDetails.xml`)
- `SeriesCreatorsDialog` → `wcs/ui/dialogs/DialogSeriesCreators.py` (XML: `details_extras/DialogActorDetails.xml`)
- „Guide“ dialogy: TMDb/Webshare/AI/Library/Remote → `wcs/ui/dialogs/guide/**` (nebo reuse z `wcs/login/**`, odstranit duplicity; pozor na `LibraryGuideDialog`).

### Cíl
- `wcs/router.py` obsahuje pouze mapování `action` → volání. Žádné `WindowXMLDialog` třídy ani UI logika.

### TODO
Poznámka k zaškrtávání: Hotové položky vždy označ změnou původního řádku na `[x]` (in‑place). Nepřidávej duplicitní řádky ani dodatečné komentáře; zachovej původní pořadí položek.
- [x] Vyčlenit `SimilarMoviesDialog` do `wcs/ui/dialogs/DialogSimilarMovies.py` a upravit akci `display_similar_movies_dialog` (bez změny chování).
- [x] Vyčlenit `SimilarSeriesDialog` do `wcs/ui/dialogs/DialogSimilarSeries.py` a upravit akci `display_similar_series_dialog`.
- [x] Vyčlenit `ActorDialog` do `wcs/ui/dialogs/DialogActorDetails.py` a upravit akci `display_actor_dialog`.
- [x] Vyčlenit `DirectorDialog` do `wcs/ui/dialogs/DialogDirectorDetails.py` a upravit akci `display_director_dialog`.
- [x] Vyčlenit `CollectionDialog` do `wcs/ui/dialogs/DialogCollectionDetails.py` a upravit akci `display_collection_dialog`.
- [x] Vyčlenit `SeriesCreatorsDialog` do `wcs/ui/dialogs/DialogSeriesCreators.py` a upravit akci `display_series_creators_dialog`.
- [x] Sjednotit „Guide“ dialogy do `wcs/ui/dialogs/guide/**` nebo reuse z `wcs/login/**` a odstranit duplicity.
  - [x] 1/5: TMDb guide (DialogTMDbGuide)
  - [x] 2/5: Webshare guide (DialogWebshareGuide)
  - [x] 3/5: AI guide (DialogAIGuide)
  - [x] 4/5: Library guide (DialogLibraryGuide)
  - [x] 5/5: Remote guide (DialogRemoteGuide)
- [x] Ověřit, že `wcs/router.py` už neobsahuje žádné `WindowXMLDialog` třídy.
- [ ] Nahradit přímé `requests` v `wcs/router.py` voláním přes `wcs/metadata/TMDbClient.py` (použít existující funkce)
  - [x] `action == 'settings'` (blok validace TMDb klíče): použít `TMDbClient.check_tmdb_api_key_validity(addon)` místo přímého `requests.get` na `/configuration`.
  - [ ] `action == 'play_text_game'` (větev pro `media_type == 'series'`/`'tv'`): použít `TMDbClient.fetch_tmdb_item_detail('tv', tmdb_id, {}, addon)` místo přímého `requests.get` na `/tv/{id}`.

- [ ] Nahradit přímé `requests` mimo router voláním přes `wcs/metadata/TMDbClient.py`
  - [ ] `wcs/ui/dialogs/DialogSeriesCreators.py`: `/tv/{id}`, `/person/{id}` → použít `TMDbClient.fetch_tmdb_item_detail('tv', tmdb_id, {...}, addon)` a `TMDbClient.fetch_tmdb_item_detail('person', person_id, {...}, addon)` (případně `TMDbClient.get_person_details`).
  - [ ] `wcs/ui/dialogs/DialogSimilarSeries.py`: `/tv/{id}/similar` → použít `TMDbClient.fetch_tmdb_list(f"tv/{tmdb_id}/similar", {...}, addon)`.
  - [ ] `wcs/ui/dialogs/DialogSimilarMovies.py`: `/movie/{id}/similar` → použít `TMDbClient.fetch_tmdb_list(f"movie/{tmdb_id}/similar", {...}, addon)`.
  - [ ] `wcs/ui/dialogs/DialogWcsMyList.py`: volání na `/movie`, `/tv`, `/tv/{id}/season/{n}`, `/search/movie` → použít `TMDbClient.fetch_tmdb_item_detail`, `TMDbClient.fetch_tmdb_list`, příp. existující `TMDbClient.get_movie_detailed_info`/`TMDbClient.get_genres`.
  - [x] `wcs/login/DialogTMDbLogin.py`: validace klíče → používat JEN `TMDbClient.check_tmdb_api_key_validity(addon, api_key)`; v nastavení ukládat pouze platný klíč (401 blokuje), ostatní chyby neblokují ukládání.
