# Milionář – Prompty pro typ Tvůrce seriálů (kopírovatelné do kódu)

Níže jsou finální, samostatné prompty pro typ hry Tvůrce seriálů. Každý prompt je nezávislý inference call, respektuje globální obtížnost `{difficulty_header}` a má jednotný JSON výstup. Bloky lze přímo vložit do funkcí v `wcs/ai_handler.py`.

---

## SNADNÁ (Tvůrce seriálů)

```python
prompt = f"""{difficulty_header}Jsi expert na seriálové kvízy. Vytvoř přesně 3 SNADNÉ otázky pro kvíz typu "Chcete být milionářem" o tvůrci seriálů {creator_name}.{bio_info}{shows_info}

OBTÍŽNOST: SNADNÁ - "Základní znalosti kariéry"
TÉMATA: Narození, nejslavnější seriály, základní ocenění, kariérní fakta
CÍLOVÁ SKUPINA: Každý fanoušek seriálů pozná

PŘÍKLADY TÉMAT:
- Kdy se tvůrce narodil?
- Jaký je jeho nejslavnější seriál?
- Za jaký seriál získal ocenění?
- V jakém roce debutoval?
- Jaké je jeho rodné město?
- Který seriál ho proslavil?
- Jaké má základní vzdělání?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být JEDNODUCHÉ pro běžného fanouška
- Zaměř se POUZE na základní fakta a nejslavnější díla
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```

---

## STŘEDNÍ (Tvůrce seriálů)

```python
prompt = f"""{difficulty_header}Jsi expert na seriálové kvízy. Vytvoř přesně 3 STŘEDNÍ otázky pro kvíz typu "Chcete být milionářem" o tvůrci seriálů {creator_name}.{bio_info}{shows_info}

OBTÍŽNOST: STŘEDNÍ - "Pozornost k detailům kariéry"
TÉMATA: Konkrétní seriály, spolupráce s herci a režiséry, technika tvorby, méně známá díla
CÍLOVÁ SKUPINA: Pozorný fanoušek si všimne

PŘÍKLADY TÉMAT:
- Jakou techniku použil v [konkrétním seriálu]?
- S jakým hercem spolupracoval nejčastěji?
- Jaký je jeho charakteristický styl?
- V kterém roce vytvořil [seriál]?
- Jaké má vzdělání v tvorbě?
- S jakým režisérem spolupracoval?
- Jaký žánr preferuje?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být STŘEDNÍ obtížnosti
- Zaměř se na DETAILY kariéry a spolupráce
- Vyžadují lepší znalost tvůrce, ne jen základní fakta
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```

---

## TĚŽKÁ (Tvůrce seriálů)

```python
prompt = f"""{difficulty_header}Jsi televizní historik. Vytvoř přesně 3 TĚŽKÉ otázky pro kvíz typu "Chcete být milionářem" o tvůrci seriálů {creator_name}.{bio_info}{shows_info}

OBTÍŽNOST: TĚŽKÁ - "Tvůrčí erudice"
TÉMATA: Detailní trivia, specifická ocenění, méně známé projekty, historické souvislosti
CÍLOVÁ SKUPINA: Skutečný znalec tvůrce pozná

PŘÍKLADY TÉMAT:
- Za jaký seriál byl nominován na [konkrétní rok]?
- V kterém divadle působil?
- Jaké má konkrétní ocenění z [festival]?
- V jakém roce debutoval v televizi?
- Jaké má vzdělání v tvorbě?
- Který méně známý projekt vytvořil?
- Jaké má konkrétní hobby nebo zájmy?
- V kterém roce získal [konkrétní cenu]?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být TĚŽKÉ - pro skutečné znalce
- Zaměř se na DETAILNÍ TRIVIA a méně známé fakta
- Kombinace znalosti tvůrce + televizní kultury
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```