## Autoplay epizod z doplňku – jednoduchá specifikace

- Cíl: Stejná UX jako v knihovně Kodi, ale pro epizody spuštěné z doplňku (TMDb menu, Moje seriály). Globální nastavení.

### Kdy se dialog otevře
- Při přehrávání epizody spuštěné z doplňku.
- X sekund před koncem epizody se otevře `DialogAutoplayCountdown` se stejnými tlačítky a chováním jako v knihovně.

### Odkud bereme data (jen doplněk)
- Pouze z dat aktuálního seznamu v doplňku (cache), bez síťových dotazů.
- „Další epizoda“ = další položka v pořadí v aktuální sezóně.
- Pokud je aktuální epizoda poslední, vezmi první epizodu následující sezóny (pokud existuje).
- Obrázek v dialogu = still obrázek další epizody ze seznamu (přímo to, co už je v UI).

### Nastavení (globální reuse)
- Použít stávající klíče: `autoplay_enabled_global`, `autoplay_countdown_seconds`, `autoplay_trigger_seconds`.
- V `resources/settings.xml` upravit texty na globální (už ne „pouze pro knihovnu“).

### Integrace (bez zásahu do knihovny)
- Nechat knihovní logiku beze změny (žádné úpravy `PlayerMonitor`).
- Rozšířit `AutoplayManager` o „addon“ režim a registraci kontextu doplňku.
- Registrace kontextu při startu přehrávání epizody z doplňku:
  - `DialogWcsSearch.py` (mimo knihovnu) a `DialogWcsMyList.py` předají: `series_name`, `tmdb_id`, `current S/E`, seznam epizod v sezóně (ordered) + stilly, seznam sezón (ordered) pro přechod.
- Přehrání další epizody spustit přes `PlayMedia(plugin://...action=play...)` (stejně jako dnes z doplňku).

### Klíčové soubory
- `wcs/playback/DialogAutoplayCountdown.py` – `AutoplayManager`: addon kontext, výpočet next epizody z kontextu, volání dialogu.
- `wcs/ui/dialogs/DialogWcsSearch.py` – registrace kontextu při přehrání epizody mimo knihovnu.
- `wcs/ui/dialogs/DialogWcsMyList.py` – registrace kontextu při přehrání epizody z „Moje seriály“.
- `resources/settings.xml` – úprava textů nastavení na globální použití.

### Akce v dialogu
- Přehrát ihned -> hned spustí další epizodu.
- Zrušit -> nic neudělá.
- Timeout -> automaticky spustí další epizodu.

### Okraje
- Pokud neexistuje další epizoda/sezóna, dialog se neotevře.
- Žádné duplicitní dialogy s knihovnou.
- Žádné fallbacky obrázků; vždy still příští epizody ze seznamu doplňku.


