# Problém s chybějícími metadaty v DialogMediaInfoWithGame.py - VYŘEŠENO

## Popis problému
Při spuštění filmu z kontextového menu se nezobrazovaly kompletní metadata v `DialogMediaInfoWithGame.py` - chyběl žánr, rating a runtime.

## Řešení - IMPLEMENTOVÁNO
Kontextové menu nyní používá **stejnou logiku** jako search dialog - doplňuje chybějící metadata z knihovny Kodi před voláním `play_movie_from_addon()` funkce.

## Co bylo implementováno
1. ✅ **Upraven router** - `play_movie_from_addon` akce nyní doplňuje metadata z knihovny
2. ✅ **Automatické doplnění metadat** - rating, genre, director, runtime se získají z knihovny Kodi
3. ✅ **Zachována funkcionalita** - film se přehraje a zobrazí se s kompletními metadaty
4. ✅ **Vylepšeno kontextové menu** - položka "PŘEHRÁT IHNED" má výraznou zelenou barvu

## Implementované změny

### 1. Router (wcs/router.py)
```python
# Doplnění chybějících metadat z knihovny před voláním play_movie_from_addon
try:
    from wcs.library.LibraryManager import get_movie_metadata_from_library
    metadata = get_movie_metadata_from_library(title, year) or {}
    # Automatické doplnění rating, genre, director, runtime
except Exception as e:
    xbmc.log(f"[plugin.video.milionar] Router: Error getting metadata: {e}", level=xbmc.LOGWARNING)
```

### 2. Kontextové menu (wcs/ui/ContextMenu.py)
- Změněna barva položky "PŘEHRÁT IHNED" na výraznou zelenou (`FF00FF00`)
- Text změněn z "Přehrát ihned(beta)" na "PŘEHRÁT IHNED"

### 3. Lokalizace (strings.po)
- ID 30060: "Přehrát ihned(beta)" → "PŘEHRÁT IHNED"

## Výsledek
- ✅ Film se přehraje z kontextového menu
- ✅ Metadata se zobrazí kompletně v `DialogMediaInfoWithGame.py`
- ✅ Žánr, rating a runtime jsou dostupné
- ✅ Kontextové menu má výraznější vzhled

## Klíčové soubory
- `wcs/router.py` - doplnění metadat z knihovny
- `wcs/ui/ContextMenu.py` - vylepšení vzhledu menu
- `resources/language/resource.language.cs_cz/strings.po` - lokalizace

## Datum implementace
16.8.2025 - Problém úspěšně vyřešen a otestován
