# Přehled doplňku Milionář

**Stav: HOTOVO** ✅

Tento dokument poskytuje komplexní přehled o účelu, funkcích a typických scénářích použití doplňku Milionář pro Kodi.

## Poslání a účel

Doplněk Milionář je multifunkční centrum pro zábavu, které transformuje Kodi v pokročilou platformu pro správu a konzumaci mediálního obsahu. Jeho hlavním cílem je poskytnout uživatelům jednotné, rychlé a intuitivní rozhraní, které kombinuje vyhledávání, přehrávání, správu obsahu a interaktivní prvky, jako jsou hry a AI asistence.

## Klíčové vlastnosti a moduly

Funkcionalita doplňku je rozdělena do několika logických modulů, které spolupracují na zajištění plynulého uživatelského zážitku.

### Procházení a správa obsahu (UI & Metadata)

Jádro doplňku, které uživatelům umožňuje objevovat nový obsah.

-   **Pokročilé vyhledávání**: Rychlé a efektivní vyhledávání filmů i seriálů s možností filtrování.
-   **Obohacené detaily**: Zobrazení podrobných informací o titulech (popis, hodnocení, žánry, herci, tvůrci) díky integraci s **TMDb** a **ČSFD**.
-   **Objevování obsahu**: Nabídka podobných titulů, procházení filmografie herců a režisérů a správa kolekcí.
-   **Vlastní UI**: Doplněk využívá vlastní sadu dialogových oken pro zajištění konzistentního a moderního vzhledu napříč celou aplikací.

### Přehrávání a stahování (Webshare & Playback)

Modul zajišťující bezproblémové přehrávání a přístup k souborům.

-   **Integrace Webshare**: Plná podpora služby Webshare.cz, včetně bezpečného přihlášení, správy tokenů a vyhledávání dostupných streamů.
-   **Výběr kvality**: Možnost volby preferované kvality videa před spuštěním.
-   **Inteligentní přehrávač**: Funkce jako **Autoplay** (automatické spuštění další epizody s odpočtem) a monitorování stavu přehrávače pro plynulé navázání.
-   **Stahování**: Možnost stahování souborů pro offline sledování.

### Správa osobního obsahu (Knihovna & Seznamy)

Nástroje pro personalizaci a organizaci oblíbeného obsahu.

-   **Můj seznam**: Jednoduché přidávání a odebírání filmů, seriálů a epizod do vlastního seznamu pro rychlý přístup.
-   **Integrace s knihovnou Kodi**: Možnost přidávat obsah přímo do nativní knihovny Kodi pro centralizovanou správu.
-   **Správa oblíbených**: Ukládání oblíbených herců, režisérů a dalších tvůrců.

### Interaktivita a Hry (Games)

Unikátní herní prvky, které odlišují tento doplněk od ostatních.

-   **Milionář**: Kvízová hra na motivy známé televizní soutěže, kde otázky mohou souviset s právě prohlíženým obsahem.
-   **Textové hry**: Dobrodružné textové hry generované na téma vybraného filmu či seriálu.
-   **Obecné kvízy**: Další formy kvízů pro ověření znalostí.

### Umělá Inteligence (AI)

Pokročilé funkce využívající sílu velkých jazykových modelů.

-   **AI Asistence**: Generování nápověd pro hry nebo poskytování doplňujících informací k obsahu.
-   **Text-to-Speech (TTS)**: Možnost nechat si předčítat texty, například otázky v hrách nebo informace o filmu.
-   **Podpora více providerů**: Flexibilní výběr z různých poskytovatelů AI služeb (OpenAI, Google, Anthropic, Mistral).
-   **Správa API a limitů**: Přehledné sledování využití API a správa nákladů.

## Typický scénář použití

Uživatel spustí doplněk a pomocí hlavního menu si vybere akci – například vyhledá film. Z přehledných výsledků přejde na detail, kde si může přečíst informace, prohlédnout herce nebo si zobrazit podobné tituly. Jedním kliknutím spustí přehrávání přes Webshare, případně si titul přidá do svého seznamu nebo knihovny Kodi pro pozdější sledování. Během přehrávání může využít funkci autoplay pro další epizodu. Pro zpestření si může zahrát textovou hru na téma filmu nebo si ověřit své znalosti v kvízu Milionář.
