# Autostart VIP kontrola - doplněk Milionář

## Co to dělá
Při autostartu doplňku se automaticky zkontroluje VIP expirace Webshare účtu a zobrazí se varování, pokud je expirace pod nastaveným thresholdem.

## Implementační plán

### 1. Rozšíření service.py
- Import `WebshareClient` pro přístup k účtu
- Načtení nastavení `webshare_vip_warn_days`
- Kontrola VIP expirace při autostartu doplňku

### 2. Logika kontroly
- Zkontrolovat, zda je autostart zapnutý
- Zkontrolovat, zda se má spustit doplněk (ne Můj seznam)
- Načíst informace o Webshare účtu
- Porovnat datum expirace s thresholdem
- Zobrazit notifikaci s varováním

### 3. Nové lokalizace
- **#32199**: "VIP expires soon" / "VIP brzy vyprší"
- **#32200**: "VIP expires on {date}" / "VIP vyprší {date}"

### 4. Nastavení
- Používá existující `webshare_vip_warn_days` z settings.xml
- Kontrola se provádí pouze při autostartu doplňku

## Implementované soubory

### 1. service.py
- Rozšíření o VIP kontrolu
- Integrace s WebshareClient
- Podmíněné notifikace

### 2. Lokalizace
- Nové stringy pro VIP varování
- Podpora všech jazyků (CS, EN, SK)

## Jak to bude fungovat
1. Service se spustí při startu Kodi
2. Zkontroluje nastavení autostart
3. Pokud se má spustit doplněk (ne Můj seznam)
4. Zkontroluje VIP expiraci Webshare účtu
5. Pokud je expirace pod thresholdem, zobrazí varování
6. Pokračuje s autostartem doplňku

## Výhody
- Automatické upozornění na VIP expiraci
- Integrace s existujícím autostart systémem
- Respektuje nastavení thresholdu
- Neobtěžuje při autostartu Můj seznam

## Testování
1. Nastavit autostart doplňku
2. Nastavit `webshare_vip_warn_days` na nízkou hodnotu
3. Restart Kodi
4. Ověřit zobrazení VIP varování

## Implementováno

### 1. Nové lokalizace
- **#32199**: "VIP expires soon" / "VIP brzy vyprší"
- **#32200**: "VIP expires on {date}" / "VIP vyprší {date}"

### 2. Funkce check_vip_expiration()
- Kontrola tokenu
- Načtení threshold nastavení
- Parsování VIP info
- Extrakce data expirace
- Výpočet dnů do expirace
- Zobrazení varování

### 3. Integrace do autostartu
- Volá se pouze při spuštění doplňku (ne Můj seznam)
- Kontrola před spuštěním doplňku
- Logování pro debugging
