# Milionář – Přehled promptů a obtížností

Tento dokument popisuje systém promptů pro hru Milionář v doplňku. Všechny prompty jsou konzistentní a používají jednotný formát s dynamickou globální obtížností.

## Struktura promptů

Každý prompt obsahuje:
- **Globální obtížnost** (injektovaná přes `get_millionaire_difficulty_header()` podle nastavení doplňku)
- **Specifická obtížnost** (SNADNÁ/STŘEDNÍ/TĚŽKÁ s popisem)
- **Témata** (konkrétní oblasti otázek)
- **Cílová skupina** (kdo by měl otázky znát)
- **Doplňující instrukce** (injektované přes `get_millionaire_difficulty_instruction()` podle nastavení)
- **Příklady témat** (inspirace pro AI)
- **Formát odpovědi** (JSON struktura)
- **Důležité pravidla** (omezení a požadavky)

## Typy her

### 1. Film/Seriál/Epizoda (univerzální funkce)
```python
def generate_millionaire_easy_questions(media_type="movie", title="", plot="", genre="", episode_title="", season_number=None, episode_number=None)
def generate_millionaire_medium_questions(media_type="movie", title="", plot="", genre="", episode_title="", season_number=None, episode_number=None)
def generate_millionaire_hard_questions(media_type="movie", title="", plot="", genre="", episode_title="", season_number=None, episode_number=None)
```

### 2. Herec
```python
def generate_actor_millionaire_easy_questions(actor_name: str, bio: str = "", known_for=None)
def generate_actor_millionaire_medium_questions(actor_name: str, bio: str = "", known_for=None)
def generate_actor_millionaire_hard_questions(actor_name: str, bio: str = "", known_for=None)
```

### 3. Režisér
```python
def generate_director_millionaire_easy_questions(director_name: str, bio: str = "", known_for=None)
def generate_director_millionaire_medium_questions(director_name: str, bio: str = "", known_for=None)
def generate_director_millionaire_hard_questions(director_name: str, bio: str = "", known_for=None)
```

### 4. Tvůrce seriálů
```python
def generate_creator_millionaire_easy_questions(creator_name: str, bio: str = "", known_for=None)
def generate_creator_millionaire_medium_questions(creator_name: str, bio: str = "", known_for=None)
def generate_creator_millionaire_hard_questions(creator_name: str, bio: str = "", known_for=None)
```

### 5. Scénárista
```python
def generate_writer_millionaire_easy_questions(writer_name: str, bio: str = "", known_for=None)
def generate_writer_millionaire_medium_questions(writer_name: str, bio: str = "", known_for=None)
def generate_writer_millionaire_hard_questions(writer_name: str, bio: str = "", known_for=None)
```

## Obtížnosti

### Globální obtížnost
Kontrolována nastavením `millionaire_difficulty` (0=snadná, 1=střední, 2=těžká). Vkládá se na začátek každého promptu jako plynulá, direktivní instrukce:

- SNADNÁ (nastavení "0")  
  HLAVNÍ OBTÍŽNOST: SNADNÁ – Formuluj otázky jednoduše z obecně známých informací. Vyhýbej se detailům a insider faktům. Možnosti odpovědí musí být zřetelně odlišitelné.

- STŘEDNÍ (nastavení "1", default)  
  HLAVNÍ OBTÍŽNOST: STŘEDNÍ – Pracuj s mírnou mírou detailu nad mainstream. Můžeš použít méně známé souvislosti, ale zachovej srozumitelnost. Možnosti odpovědí musí být věrohodné, nikoli zavádějící.

- TĚŽKÁ (nastavení "2")  
  HLAVNÍ OBTÍŽNOST: TĚŽKÁ – Opírej otázky o hlubší znalosti a přesné kontexty. Využívej odbornější pojmy, pokud jsou relevantní. Možnosti odpovědí musí být velmi věrohodné a pečlivě odlišitelné až po důkladném uvážení.

### Doplňující instrukce
Dynamicky vkládané doprostřed promptu podle aktuálního nastavení obtížnosti:

- SNADNÁ  
  DOPLŇUJÍCÍ INSTRUKCE: Uplatni hlavní obtížnost v duchu základů bez detailů.

- STŘEDNÍ  
  DOPLŇUJÍCÍ INSTRUKCE: Uplatni hlavní obtížnost s mírným navýšením detailu, zároveň zachovej srozumitelnost.

- TĚŽKÁ  
  DOPLŇUJÍCÍ INSTRUKCE: Uplatni hlavní obtížnost s důrazem na hlubší znalosti a věrohodné distraktory.

Poznámka: Každá sada otázek je samostatná inference bez historie. Proto je globální obtížnost vždy součástí každého promptu a platí pro právě generované otázky.

### Specifická obtížnost (v promptu)
- SNADNÁ – "Základní znalosti kariéry/porozumění příběhu"
- STŘEDNÍ – "Pozornost k detailům kariéry/příběhu"  
- TĚŽKÁ – "Erudice" (herecká/režisérská/tvůrčí/scénáristická)

## Formát odpovědi

Všechny prompty generují JSON ve formátu:
```json
{
  "questions": [
    {
      "question": "Text otázky",
      "options": {"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }
  ]
}
```

## Pravidla

Všechny prompty dodržují:
- Přesně 3 otázky
- 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno
- Maximálně 25 znaků na možnost
- Stručné a jasné formulace

## Implementace

Všechny funkce jsou implementovány v `wcs/ai_handler.py` a používají:
- `get_millionaire_difficulty_header()` pro globální obtížnost na začátku promptu
- `get_millionaire_difficulty_instruction()` pro doplňující instrukce doprostřed promptu
- `send_prompt()` pro komunikaci s AI
- `_clean_ai_response()` pro čištění odpovědi
- `track_ai_usage()` pro sledování použití
- Konzistentní error handling

### Struktura promptu
Každý prompt má následující strukturu:
1. **Globální obtížnost** (z `get_millionaire_difficulty_header()`)
2. **Úvodní instrukce** (Jsi expert na...)
3. **Specifická obtížnost** (SNADNÁ/STŘEDNÍ/TĚŽKÁ s popisem)
4. **Témata** (konkrétní oblasti otázek)
5. **Cílová skupina** (kdo by měl otázky znát)
6. **Doplňující instrukce** (z `get_millionaire_difficulty_instruction()`)
7. **Příklady témat** (inspirace pro AI)
8. **Formát odpovědi** (JSON struktura)
9. **Důležité pravidla** (omezení a požadavky)