#!/usr/bin/env python3
"""
Generate masks for modal card dialog with large corner radius.
Masks must match the EXACT aspect ratio of the target controls.
"""
from PIL import Image, ImageDraw
import os

BASE_DIR = os.path.dirname(os.path.abspath(__file__))
SCALE = 4


def generate_mask(filename, width, height, radius):
    """Generate a rounded rectangle mask with antialiasing."""
    img = Image.new('RGBA', (width * SCALE, height * SCALE), (0, 0, 0, 0))
    draw = ImageDraw.Draw(img)
    draw.rounded_rectangle(
        [(0, 0), (width * SCALE - 1, height * SCALE - 1)],
        radius=radius * SCALE,
        fill=(255, 255, 255, 255)
    )
    img = img.resize((width, height), Image.LANCZOS)
    output_path = os.path.join(BASE_DIR, filename)
    img.save(output_path, 'PNG')
    print(f"Generated {filename} ({width}x{height}, radius={radius})")


# Still mask - EXACT aspect ratio 1060:300 (scaled down to 530x150)
# Control: 1060x300, radius 30px at target size = 15px at mask size
generate_mask('still_mask_card_large.png', 530, 150, 15)

# Poster mask - EXACT aspect ratio 220:330 (scaled down to 220x330)
# Control: 220x330, radius 20px
generate_mask('poster_mask_card_large.png', 220, 330, 20)
