#!/usr/bin/env python3
"""Generate dialog_rounded_large.png - rounded rectangle mask for dialog backgrounds."""
from PIL import Image, ImageDraw

WIDTH, HEIGHT = 200, 200
RADIUS = 35
SCALE = 4  # Antialiasing upscale factor

# Create at high resolution for smooth edges
img = Image.new('RGBA', (WIDTH * SCALE, HEIGHT * SCALE), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

draw.rounded_rectangle(
    [(0, 0), (WIDTH * SCALE - 1, HEIGHT * SCALE - 1)],
    radius=RADIUS * SCALE,
    fill=(255, 255, 255, 255)
)

# Downscale with LANCZOS for antialiased edges
img = img.resize((WIDTH, HEIGHT), Image.LANCZOS)
img.save('dialog_rounded_large.png', 'PNG')
print(f'Generated: {WIDTH}x{HEIGHT}, radius={RADIUS}px, 4x antialiased')
