#!/usr/bin/env python3
"""Generate pill-shaped texture for ladder rows (260x48, full pill radius)."""
from PIL import Image, ImageDraw
import os

WIDTH, HEIGHT = 260, 48
RADIUS = HEIGHT // 2  # Full pill = 24px radius
SCALE = 4  # Antialiasing

# High-res render
img = Image.new('RGBA', (WIDTH * SCALE, HEIGHT * SCALE), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)
draw.rounded_rectangle(
    [(0, 0), (WIDTH * SCALE - 1, HEIGHT * SCALE - 1)],
    radius=RADIUS * SCALE,
    fill=(255, 255, 255, 255)
)

# Downscale with antialiasing
img = img.resize((WIDTH, HEIGHT), Image.LANCZOS)

# Save
output_path = os.path.join(
    os.path.dirname(os.path.dirname(os.path.abspath(__file__))),
    'resources', 'media', 'game_ladder_pill.png'
)
img.save(output_path, 'PNG')
print(f"Generated: {output_path} ({WIDTH}x{HEIGHT}, radius={RADIUS})")
