#!/usr/bin/env python3
"""Generate check icon for watched indicator."""
from PIL import Image, ImageDraw

# Dimensions
WIDTH, HEIGHT = 64, 64
SCALE = 4  # Antialiasing

# Create at higher resolution for antialiasing
img = Image.new('RGBA', (WIDTH * SCALE, HEIGHT * SCALE), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Circle background
draw.ellipse(
    [(0, 0), (WIDTH * SCALE - 1, HEIGHT * SCALE - 1)],
    fill=(255, 255, 255, 255)
)

# Checkmark
LINE_WIDTH = int(8 * SCALE)
points = [
    (int(15 * SCALE), int(32 * SCALE)),  # Start
    (int(26 * SCALE), int(45 * SCALE)),  # Middle
    (int(50 * SCALE), int(20 * SCALE)),  # End
]
draw.line(points[0:2], fill=(0, 0, 0, 0), width=LINE_WIDTH)
draw.line(points[1:3], fill=(0, 0, 0, 0), width=LINE_WIDTH)

# Cut out checkmark with alpha
# Redraw with proper alpha mask approach
img = Image.new('RGBA', (WIDTH * SCALE, HEIGHT * SCALE), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# White circle
draw.ellipse(
    [(0, 0), (WIDTH * SCALE - 1, HEIGHT * SCALE - 1)],
    fill=(255, 255, 255, 255)
)

# Draw checkmark by making transparent lines
# Actually, simpler: just draw white solid circle
# Kodi will colordiffuse it green

# Downscale
img = img.resize((WIDTH, HEIGHT), Image.LANCZOS)

# Save
output_path = '/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/check_icon.png'
img.save(output_path, 'PNG')
print(f"Saved: {output_path}")
