#!/usr/bin/env python3
"""Generuje pill-shaped štítek pro provider badge."""
from PIL import Image, ImageDraw

# Rozměry štítku (plně zaoblené konce = pill shape)
# Větší rozměry pro lepší čitelnost
WIDTH, HEIGHT = 140, 32
SCALE = 4  # Antialiasing

# Vysoké rozlišení pro hladké hrany
img = Image.new('RGBA', (WIDTH * SCALE, HEIGHT * SCALE), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Pill shape = radius je polovina výšky
RADIUS = (HEIGHT * SCALE) // 2

draw.rounded_rectangle(
    [(0, 0), (WIDTH * SCALE - 1, HEIGHT * SCALE - 1)],
    radius=RADIUS,
    fill=(255, 255, 255, 255)
)

# Downscale s antialiasing
img = img.resize((WIDTH, HEIGHT), Image.LANCZOS)

# Uložení
img.save('/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/badge_pill.png', 'PNG')
print("badge_pill.png created")
