#!/usr/bin/env python3
"""Generate high-quality rounded scrollbar texture for Kodi."""
from PIL import Image, ImageDraw

# High resolution for maximum quality (4x upscale then downscale for antialiasing)
SCALE = 4
WIDTH = 20 * SCALE
HEIGHT = 100 * SCALE
RADIUS = (WIDTH // 2)

# Create high-res image with transparency
img = Image.new('RGBA', (WIDTH, HEIGHT), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Draw perfect white pill shape at high resolution
draw.rounded_rectangle(
    [(0, 0), (WIDTH - 1, HEIGHT - 1)],
    radius=RADIUS,
    fill=(255, 255, 255, 255)
)

# Downscale with high-quality LANCZOS filter for smooth antialiased edges
img = img.resize((20, 100), Image.LANCZOS)

# Save with maximum quality
output_path = '/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/scrollbar_rounded.png'
img.save(output_path, 'PNG', optimize=False)
print(f"Created: {output_path}")
print(f"Final size: 20x100px (generated at {SCALE}x for smooth antialiasing)")
