#!/usr/bin/env python3
"""Generate fanart mask with rounded TOP corners and gradient fade at bottom."""
from PIL import Image, ImageDraw

# Dimensions
WIDTH = 820
HEIGHT = 350
RADIUS = 40
SCALE = 2

# Create at higher resolution for antialiasing
w, h = WIDTH * SCALE, HEIGHT * SCALE
r = RADIUS * SCALE

# Create transparent image
img = Image.new('RGBA', (w, h), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Draw shape with ONLY top corners rounded
# Top-left rounded corner
draw.pieslice([(0, 0), (r * 2, r * 2)], 180, 270, fill=(255, 255, 255, 255))
# Top-right rounded corner
draw.pieslice([(w - r * 2, 0), (w, r * 2)], 270, 360, fill=(255, 255, 255, 255))
# Fill rest
draw.rectangle([(r, 0), (w - r, r)], fill=(255, 255, 255, 255))  # Top strip between corners
draw.rectangle([(0, r), (w, h)], fill=(255, 255, 255, 255))  # Everything below rounded part

# Apply vertical gradient to alpha channel (fade at bottom)
for y in range(h):
    # Linear gradient: full at top 60%, then fade
    if y < h * 0.6:
        alpha = 255
    else:
        progress = (y - h * 0.6) / (h * 0.4)
        alpha = int(255 * (1 - progress))
    
    for x in range(w):
        r_val, g_val, b_val, a_val = img.getpixel((x, y))
        if a_val > 0:
            new_alpha = min(a_val, alpha)
            img.putpixel((x, y), (r_val, g_val, b_val, new_alpha))

# Downscale for antialiasing
img = img.resize((WIDTH, HEIGHT), Image.LANCZOS)

# Save
output_path = '/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/fanart_mask_rounded_top.png'
img.save(output_path, 'PNG')
print(f"Created: {output_path}")
