#!/usr/bin/env python3
"""Generate a rounded white rectangle for Kodi button textures."""
from PIL import Image, ImageDraw

# Create a white rounded rectangle on transparent background
# Size should be large enough for 9-slice scaling
width, height = 100, 100
radius = 25  # Corner radius

img = Image.new('RGBA', (width, height), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Draw rounded rectangle (white fill)
draw.rounded_rectangle(
    [(0, 0), (width - 1, height - 1)],
    radius=radius,
    fill=(255, 255, 255, 255)
)

# Save
output_path = '/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/btn_rounded.png'
img.save(output_path, 'PNG')
print(f"Saved: {output_path}")
