#!/usr/bin/env python3
"""
Generate masks for Milionar game dialog in MyTV.
- game_poster_mask.png: diffuse mask for poster (280x580, radius 35px)
- game_ladder_bg.png: 9-patch background for ladder panel (280x395, radius 35px)
"""
from PIL import Image, ImageDraw
import os

BASE_DIR = os.path.dirname(os.path.abspath(__file__))
SCALE = 4


def generate_mask(filename, width, height, radius):
    """Generate a rounded rectangle mask with antialiasing."""
    img = Image.new('RGBA', (width * SCALE, height * SCALE), (0, 0, 0, 0))
    draw = ImageDraw.Draw(img)
    draw.rounded_rectangle(
        [(0, 0), (width * SCALE - 1, height * SCALE - 1)],
        radius=radius * SCALE,
        fill=(255, 255, 255, 255)
    )
    img = img.resize((width, height), Image.LANCZOS)
    output_path = os.path.join(BASE_DIR, filename)
    img.save(output_path, 'PNG')
    print(f"Generated {filename} ({width}x{height}, radius={radius})")


# Poster mask -- diffuse mask for poster image
# Control: 280x580, radius 35px
generate_mask('game_poster_mask.png', 280, 580, 35)

# Ladder background -- white fill, will be tinted by colordiffuse in XML
# Control: 280x395, radius 35px (used as 9-slice with border)
generate_mask('game_ladder_bg.png', 280, 395, 35)
