#!/usr/bin/env python3
"""Generate card_mask_large.png - mask for series detail fanart (600x680 control)."""
from PIL import Image, ImageDraw
import os

SCALE = 4
W, H = 300, 340  # Half of 600x680, same aspect ratio
RADIUS = 25  # Large radius for visible rounded corners

img = Image.new('RGBA', (W * SCALE, H * SCALE), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)
draw.rounded_rectangle(
    [(0, 0), (W * SCALE - 1, H * SCALE - 1)],
    radius=RADIUS * SCALE,
    fill=(255, 255, 255, 255)
)
img = img.resize((W, H), Image.LANCZOS)

output_path = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'card_mask_large.png')
img.save(output_path, 'PNG')
print(f"Generated card_mask_large.png ({W}x{H}, radius={RADIUS})")
