#!/usr/bin/env python3
"""Generate pixel-perfect gradient for Kodi top bar overlay.
Smooth continuous fade from top to bottom, no solid zones.
Mimics original Kodi OSD gradient - gentle, seamless transition.
Color controlled by Kodi colordiffuse attribute."""

from PIL import Image
import math

# Exact bar dimensions - no stretching needed
WIDTH = 1920
HEIGHT = 195

img = Image.new('RGBA', (WIDTH, HEIGHT), (0, 0, 0, 0))

for y in range(HEIGHT):
    # t = 0.0 at top, 1.0 at bottom
    t = y / (HEIGHT - 1)
    # Smooth ease-out: quadratic curve for gentle seamless fade
    # alpha = 255 at top, 0 at bottom, smooth all the way
    alpha = int(255 * (1.0 - t) ** 1.5)
    
    row = [(255, 255, 255, alpha)] * WIDTH
    for x in range(WIDTH):
        img.putpixel((x, y), (255, 255, 255, alpha))

output_path = 'gradient_top_fade.png'
img.save(output_path, 'PNG')
print(f"Generated {output_path} ({WIDTH}x{HEIGHT})")
print(f"Alpha at top: 255, bottom: 0")
print(f"Curve: (1-t)^1.5 smooth ease-out")
