#!/usr/bin/env python3
"""Generate a left-to-right fade gradient texture for Kodi UI.

Creates a horizontal gradient from white (opaque) on the left
to fully transparent on the right. Color is controlled by Kodi's colordiffuse.
"""
from PIL import Image

WIDTH, HEIGHT = 256, 4

img = Image.new('RGBA', (WIDTH, HEIGHT), (0, 0, 0, 0))

for x in range(WIDTH):
    alpha = int(255 * (1.0 - x / (WIDTH - 1)))
    for y in range(HEIGHT):
        img.putpixel((x, y), (255, 255, 255, alpha))

output = '/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/gradient_left_fade.png'
img.save(output, 'PNG')
print(f"Created: {output}")
