#!/usr/bin/env python3
"""Generate smooth bottom gradient texture.
Transparent at top, white at bottom with ease-in curve.
Replaces old gradient_bottom.png which had harsh edges."""

from PIL import Image

WIDTH = 1920
HEIGHT = 540

img = Image.new('RGBA', (WIDTH, HEIGHT), (0, 0, 0, 0))

for y in range(HEIGHT):
    # t = 0.0 at top (transparent), 1.0 at bottom (opaque)
    t = y / (HEIGHT - 1)
    # Smooth ease-in: t^1.5 for gentle start
    alpha = int(255 * (t ** 1.5))
    
    for x in range(WIDTH):
        img.putpixel((x, y), (255, 255, 255, alpha))

output_path = 'gradient_bottom.png'
img.save(output_path, 'PNG')
print(f"Generated {output_path} ({WIDTH}x{HEIGHT})")
print(f"Alpha at top: 0, bottom: 255")
print(f"Curve: t^1.5 smooth ease-in")
