#!/usr/bin/env python3
"""Generate rounded rectangle background for search result items."""
from PIL import Image, ImageDraw
import os

SCRIPT_DIR = os.path.dirname(os.path.abspath(__file__))

# Item background: 984x90 with rounded corners
# Generated at 2x for antialiasing (border texture stretching handles scaling)
WIDTH, HEIGHT = 256, 64
SCALE = 4
W, H = WIDTH * SCALE, HEIGHT * SCALE
RADIUS = 48  # Rounded corners at 4x scale (~12px at 1x)

img = Image.new('RGBA', (W, H), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# White fill -- Kodi colors via colordiffuse
draw.rounded_rectangle(
    [(0, 0), (W - 1, H - 1)],
    radius=RADIUS,
    fill=(255, 255, 255, 255)
)

img = img.resize((WIDTH, HEIGHT), Image.LANCZOS)

output = os.path.join(SCRIPT_DIR, 'item_bg_rounded.png')
img.save(output, 'PNG')
print(f'Generated: {output}')
print('Done!')
