#!/usr/bin/env python3
"""Generate pill-shaped quality badge icons for search dialog."""
from PIL import Image, ImageDraw, ImageFont
import os

SCRIPT_DIR = os.path.dirname(os.path.abspath(__file__))

# Dimensions (will be used at 1x in Kodi, generated at 4x for antialiasing)
WIDTH, HEIGHT = 80, 32
SCALE = 4
W, H = WIDTH * SCALE, HEIGHT * SCALE
RADIUS = H // 2  # Full pill shape

# Quality definitions: (filename_suffix, label)
QUALITIES = [
    ('4k', '4K'),
    ('1080p', '1080p'),
    ('720p', '720p'),
    ('480p', '480p'),
    ('sd', 'SD'),
]

for suffix, label in QUALITIES:
    img = Image.new('RGBA', (W, H), (0, 0, 0, 0))
    draw = ImageDraw.Draw(img)
    
    # White fill -- color applied via colordiffuse in XML
    draw.rounded_rectangle(
        [(0, 0), (W - 1, H - 1)],
        radius=RADIUS,
        fill=(255, 255, 255, 255)
    )
    
    # Downscale with antialiasing
    img = img.resize((WIDTH, HEIGHT), Image.LANCZOS)
    
    output = os.path.join(SCRIPT_DIR, f'icon_quality_{suffix}.png')
    img.save(output, 'PNG')
    print(f'Generated: {output}')

print('Done!')
