#!/usr/bin/env python3
"""Generate eye icon for watched indicator."""
from PIL import Image, ImageDraw

# Dimensions
WIDTH, HEIGHT = 128, 80
SCALE = 4  # Antialiasing

# Create at higher resolution for antialiasing
w, h = WIDTH * SCALE, HEIGHT * SCALE
img = Image.new('RGBA', (w, h), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Eye parameters
cx, cy = w // 2, h // 2  # Center
eye_width = int(w * 0.85)
eye_height = int(h * 0.75)
stroke = int(10 * SCALE)

# Draw outer eye shape (almond shape using arcs)
# Upper lid
draw.arc(
    [(cx - eye_width // 2, cy - eye_height), (cx + eye_width // 2, cy + eye_height)],
    start=200, end=340,
    fill=(255, 255, 255, 255),
    width=stroke
)
# Lower lid
draw.arc(
    [(cx - eye_width // 2, cy - eye_height), (cx + eye_width // 2, cy + eye_height)],
    start=20, end=160,
    fill=(255, 255, 255, 255),
    width=stroke
)

# Outer circle of iris
iris_r = int(28 * SCALE)
draw.ellipse(
    [(cx - iris_r, cy - iris_r), (cx + iris_r, cy + iris_r)],
    outline=(255, 255, 255, 255),
    width=stroke
)

# Inner pupil circle
pupil_r = int(12 * SCALE)
draw.ellipse(
    [(cx - pupil_r, cy - pupil_r), (cx + pupil_r, cy + pupil_r)],
    fill=(255, 255, 255, 255)
)

# Highlight/reflection
highlight_r = int(6 * SCALE)
hx, hy = cx - int(5 * SCALE), cy - int(8 * SCALE)
draw.ellipse(
    [(hx - highlight_r, hy - highlight_r), (hx + highlight_r, hy + highlight_r)],
    fill=(0, 0, 0, 0)  # Transparent highlight cutout
)

# Downscale with antialiasing
img = img.resize((WIDTH, HEIGHT), Image.LANCZOS)

# Save
output_path = '/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/watched_eye_icon.png'
img.save(output_path, 'PNG')
print(f"Saved: {output_path}")
