#!/usr/bin/env python3
"""Generuje still_mask_rounded.png - masku pro zaoblení thumbnail/still obrázků."""
from PIL import Image, ImageDraw

SCALE = 4
W, H = 200, 113  # 16:9 poměr
RADIUS = 25

img = Image.new('RGBA', (W * SCALE, H * SCALE), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)
draw.rounded_rectangle(
    [(0, 0), (W * SCALE - 1, H * SCALE - 1)],
    radius=RADIUS * SCALE,
    fill=(255, 255, 255, 255)
)
img = img.resize((W, H), Image.LANCZOS)
img.save(__file__.replace('generate_still_mask_rounded.py', 'still_mask_rounded.png'), 'PNG')
print(f"Generated still_mask_rounded.png ({W}x{H}, radius={RADIUS})")
