# wcs/localization.py

# Pomocné funkce pro načítání lokalizovaných řetězců z addon objektu

def get_localized_string(addon, string_id):
    """
    Vrátí lokalizovaný řetězec podle ID z daného addon objektu.
    """
    return addon.getLocalizedString(string_id)

# Wrapper pro jednodušší použití v ostatních modulech (volitelné)
class Localizer:
    def __init__(self, addon):
        self.addon = addon
    def _(self, string_id):
        return self.addon.getLocalizedString(string_id)

# Načítání a správa lokalizovaných řetězců (bude implementováno v dalších krocích) 