# Architektura doplňku Milionář

**Stav: HOTOVO** ✅

Tento dokument popisuje finální architekturu doplňku po dokončeném refaktoringu. Cílem je poskytnout jasný a přehledný pohled na jednotlivé vrstvy, moduly a jejich vzájemné vazby.

## Celkové schéma a tok dat

Doplněk je navržen jako modulární aplikace řízená akcemi z prostředí Kodi.

1.  **Vstupní bod**: Kodi spustí doplněk (`main.py`) a předá mu parametry (URL s `action`).
2.  **Směrování (Routing)**: Klíčový soubor `wcs/router.py` přijme parametry, analyzuje požadovanou akci a funguje jako centrální orchestrátor, který rozhoduje, která část logiky se má provést.
3.  **Doménová logika**: Na základě akce router volá specifické moduly, které se starají o konkrétní domény:
    *   `metadata`: Komunikace s externími API (TMDb, ČSFD) pro získání informací o filmech a seriálech, včetně cachování.
    *   `webshare`: Správa přihlášení k Webshare, vyhledávání streamů a řešení přehrávatelných odkazů.
    *   `search`: Logika pro vyhledávání filmů a seriálů.
    *   `library`: Správa lokální knihovny Kodi (přidávání, odebírání položek).
    *   `ai`: Integrace s AI službami (OpenAI, Anthropic, atd.) pro generování textů, TTS a další funkce.
    *   `games`: Herní logika (Milionář, Kvízy).
    *   `playback`: Monitorování přehrávače a správa funkcí jako autoplay.
4.  **Prezentační vrstva (UI)**:
    *   Modul `wcs/ui/UI.py` obsahuje pomocné funkce pro generování seznamů a položek v Kodi.
    *   Jednotlivé dialogy a okna (`wcs/ui/dialogs/`, `wcs/login/`, atd.) jsou implementovány jako specializované třídy, které využívají XML soubory pro definici vzhledu.
5.  **Zobrazení**: Kodi vykreslí uživatelské rozhraní na základě instrukcí z Python skriptů a definic v XML souborech (`resources/skins/Default/1080i/`).
6.  **Uživatelská akce**: Uživatel interaguje s UI (vybere položku, spustí přehrávání), což opět vyvolá volání doplňku s novou akcí a cyklus se opakuje.

## Grafické schéma architektury

```
+----------------------------------+
|              Kodi                |
| (Spuštění, předání parametrů)    |
+-----------------v----------------+
                  |
+-----------------v----------------+
|          wcs/router.py           |
|      (Centrální orchestrátor)      |
+-----------------v----------------+
                  |
+-----------------v-----------------------------------------------------------------+
|                 Doménové moduly (složky ve wcs/)                                    |
|                                                                                 |
|   +----------+  +----------+  +----------+  +----------+  +----------+  +----------+  |
|   | metadata |  | webshare |  |  search  |  | library  |  |    ai    |  |  games   |  |
|   +----------+  +----------+  +----------+  +----------+  +----------+  +----------+  |
|                                                                                 |
+-----------------v-----------------------------------------------------------------+
                  |
+-----------------v----------------+
|      Prezentační vrstva (UI)     |
| (wcs/ui/, wcs/login/, atd.)      |
+-----------------v----------------+
                  |
+-----------------v----------------+
|          XML Skiny (GUI)         |
|   (resources/skins/...)          |
+----------------------------------+
```

## Finální struktura souborů

Níže je finální a aktuální struktura klíčových adresářů a souborů projektu.

### Python soubory (`wcs/`)

```
plugin.video.milionar/
└─ wcs/
   ├─ router.py
   ├─ utils.py
   ├─ localization.py
   ├─ user_data.py
   ├─ ai/
   │  ├─ AIHandler.py
   │  ├─ AIProvider.py
   │  ├─ AnthropicClient.py
   │  ├─ DialogAIDebugRequest.py
   │  ├─ GoogleClient.py
   │  ├─ MistralClient.py
   │  ├─ OpenAIClient.py
   │  ├─ TTSClient.py
   │  ├─ UsageTracker.py
   │  └─ UsageUI.py
   ├─ games/
   │  ├─ AdventureGame.py
   │  ├─ DialogShowCorrectAnswer.py
   │  ├─ DialogWcsTextGame.py
   │  ├─ GameManager.py
   │  ├─ MillionaireGame.py
   │  └─ QuizGame.py
   ├─ library/
   │  └─ LibraryManager.py
   ├─ login/
   │  ├─ DialogAILogin.py
   │  ├─ DialogLibraryFolder.py
   │  ├─ DialogTMDbLogin.py
   │  └─ DialogWebshareLogin.py
   ├─ metadata/
   │  ├─ CSFDClient.py
   │  ├─ TMDbCache.py
   │  └─ TMDbClient.py
   ├─ playback/
   │  ├─ DialogAutoplayCountdown.py
   │  ├─ DialogEpisodeInfoWithGame.py
   │  ├─ DialogMovieInfoWithGame.py
   │  └─ PlayerMonitor.py
   ├─ search/
   │  ├─ MovieSearch.py
   │  └─ SeriesSearch.py
   ├─ ui/
   │  ├─ ContextMenu.py
   │  ├─ UI.py
   │  └─ dialogs/
   │     ├─ DialogWcsDetails.py
   │     ├─ DialogWcsMyList.py
   │     └─ DialogWcsSearch.py
   └─ webshare/
      ├─ DownloadManager.py
      └─ WebshareClient.py
```

### XML Soubory (`resources/skins/Default/1080i/`)

```
resources/skins/Default/1080i/
├─ ai/
│  └─ DialogAIDebugRequest.xml
├─ details_extras/
│  ├─ DialogActorDetails.xml
│  ├─ DialogCollectionDetails.xml
│  ├─ DialogDirectorDetails.xml
│  ├─ DialogSimilarMovies.xml
│  ├─ DialogWcsDetails.xml
│  └─ DialogWcsMyList.xml
├─ games/
│  ├─ DialogShowCorrectAnswer.xml
│  └─ DialogWcsTextGame.xml
├─ guide/
│  ├─ DialogAIGuide.xml
│  ├─ DialogLibraryGuide.xml
│  ├─ DialogRemoteGuide.xml
│  ├─ DialogTMDbGuide.xml
│  └─ DialogWebshareGuide.xml
├─ login/
│  ├─ DialogAILogin.xml
│  ├─ DialogLibraryFolder.xml
│  ├─ DialogTMDbLogin.xml
│  └─ DialogWebshareLogin.xml
├─ notifications/
│  ├─ classic/
│  │  ├─ DialogAutoplayCountdown.xml
│  │  ├─ DialogEpisodeInfoWithGame.xml
│  │  └─ DialogMovieInfoWithGame.xml
│  ├─ minimal/
│  │  ├─ DialogAutoplayCountdown.xml
│  │  ├─ DialogEpisodeInfoWithGame.xml
│  │  └─ DialogMovieInfoWithGame.xml
│  └─ modern/
│     ├─ DialogAutoplayCountdown.xml
│     ├─ DialogEpisodeInfoWithGame.xml
│     └─ DialogMovieInfoWithGame.xml
├─ search/
│  └─ DialogWcsSearch.xml
```

Tímto je dokumentace architektury a struktury projektu aktualizována a odpovídá finálnímu stavu.
