import xbmcgui
import xbmcaddon
import os
from wcs.ui.dialogs.guide.DialogDownloadGuide import DownloadGuideDialog

DIALOG_XML = 'login/DialogDownloadFolder.xml'

"""Dialog pro volbu složky pro stahování; používá sjednocený DownloadGuideDialog."""

class DownloadFolderDialog(xbmcgui.WindowXMLDialog):
    def __init__(self, xmlFilename, addonPath, skin='Default', theme='1080i', **kwargs):
        super().__init__(xmlFilename, addonPath, skin, theme)
        self.addon = kwargs.get('addon')
        self.result = False

    def onInit(self):
        self.getControl(7301).setLabel('Nastavení složky pro stahování')
        self.getControl(7302).setLabel('Pro stahování souborů je nutné vybrat složku pro stahování.')
        self.getControl(7201).setLabel('Vybrat složku')

    def onClick(self, controlId):
        if controlId == 7201:
            setting_id = 'dfolder'
            label = 'Složka pro stahování'
            folder = xbmcgui.Dialog().browse(3, label, 'video')
            if folder and os.path.isdir(folder):
                self.addon.setSetting(setting_id, folder)
                self.result = True
                self.close()
        elif controlId == 7202:
            # Otevřít návod jako WindowXMLDialog s podporou zavření
            try:
                guide_dialog = DownloadGuideDialog(
                    'guide/DialogDownloadGuide.xml',
                    self.addon.getAddonInfo('path'),
                    'Default',
                    '1080i'
                )
                guide_dialog.doModal()
                del guide_dialog
            except Exception as e:
                xbmcgui.Dialog().ok("Chyba", f"Nelze otevřít návod: {e}")
        elif controlId == 7203:
            self.close()

def show_download_folder_dialog(addon):
    dialog = DownloadFolderDialog(
        DIALOG_XML,
        addon.getAddonInfo('path'),
        'Default',
        '1080i',
        addon=addon
    )
    dialog.doModal()
    result = dialog.result
    del dialog
    return result
