# 011 - Kraska Browse (Stream Cinema)

**Status:** COMPLETED
**Updated:** 2026-02-22 23:25

---

## Ucel

Menu polozka "Kraska" umoznuje prohlizeni katalogu Stream Cinema pres KRA.sk. Zobrazuje kategorie (Filmy, Serialy, Dokumentarni...), sub-slozky a konkretni tituly s moznosti prehrani.

---

## Architektura

```
Router (3 akce)
    |
    +-- kraska_browse → Root menu (kategorie)
    +-- kraska_browse_path → Sub-cesta (slozky + videa)
    +-- kraska_play → Prehrani (resolve + dialog)
    |
    v
SCBrowser.py (API volani)
    |
    v
SCClient.py (autentizace, streamy)
    |
    v
KraskaClient.py (resolve URL)
```

---

## File Map

| Soubor | Role |
|--------|------|
| [router.py L337-687](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/router.py#L337-L687) | 3 akce: `kraska_browse`, `kraska_browse_path`, `kraska_play` |
| [SCBrowser.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/streamcinema/SCBrowser.py) | SC API browser -- `browse_root()`, `browse_path()`, `parse_sc_item()` |
| [SCClient.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/streamcinema/SCClient.py) | SC API klient -- auth, `get_streams()`, `get_ident()` |
| [KraskaClient.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/kraska/KraskaClient.py) | KRA.sk resolver -- `resolve(ident)` → stream URL |

---

## 3 Router akce

### 1. `kraska_browse` (Root menu)

- Vstupni bod, vyzaduje `sc_auth_token`
- `SCBrowser.browse_root()` → seznam kategorii
- Filtruje: pouze `dir`/`ldir` typy, ignoruje `sc://` visible
- Paginace: 20 polozek/stranka
- Staticky popis pro kazdy kategorii (hardcoded `_category_plots`)
- Kazda polozka → `kraska_browse_path`

### 2. `kraska_browse_path` (Sub-cesta)

- Parametry: `sc_path`, `sc_title`, `page`
- `SCBrowser.browse_path(sc_path)` → slozky + videa
- Slozky (dir/ldir) → rekurzivne `kraska_browse_path`
- Videa → `SCBrowser.parse_sc_item()` + `enrich_with_tmdb()` → `kraska_play`
- Content type z SC response (`system.setContent`)
- Paginace: 20 polozek/stranka

### 3. `kraska_play` (Prehrani)

- Parametry: `sc_play_path`, `title`, `tmdb_id`, `year`, `poster`, `mediatype`
- `SCClient.get_streams(sc_play_path)` → vsechny streamy
- Filtruje `provider == 'kraska'`
- Konvertuje na dialog format (name, ident, size, quality, lang)
- Otevre `show_search_dialog()` s predfiltrovanymi vysledky
- Po vyberu: `SCClient.get_ident()` → `KraskaClient.resolve()` → `xbmc.Player().play()`
- Fallback: pokud zadne kraska streamy → nabidne Webshare vyhledavani

---

## Menu integrace

Router vstupni bod: polozka "Kraska" v hlavnim menu.

Viditelnost: pouze kdyz:
1. KRA.sk provider je zapnuty (`kraska_enabled`)
2. Uzivatel je prihlasen (`sc_auth_token` existuje)

Pozice v menu: 3. misto (po MyTV a MyCinema).

Volano z sidebar navigace v MyTV/MyCinema dialogu (button v 7100 listu):
```
xbmc.executebuiltin('Container.Update(plugin://ADDON_ID?action=kraska_browse)')
```

---

## Paginace

- Konstantni `PAGE_SIZE = 20`
- URL parametr `page` (0-indexed)
- "Dalsi stranka (X/Y) >>" s modrou barvou `[COLOR FF44AAFF]`
- Ikona `DefaultAddSource.png`

---

## Stream resolve flow

```
1. kraska_play → SCClient.get_streams(sc_play_path)
2. Filtr provider=='kraska' → sestav dialog polozky
3. show_search_dialog(search_results=kraska_results)
4. Uzivatel vybere stream
5. SCClient.get_ident(ident) → real_ident (SC provider path → skutecny ident)
6. KraskaClient.resolve(real_ident) → stream_url (HTTPS)
7. xbmc.Player().play(stream_url)
```

Webshare fallback: pokud zadne kraska streamy a `token` existuje → dialog "Hledat na Webshare?"

---

## Nastaveni

| Setting ID | Popis |
|------------|-------|
| `kraska_enabled` | Zapnout KRA.sk provider |
| `kraska_user` / `kraska_pass` | Prihlasovaci udaje |
| `sc_auth_token` | SC autentizacni token (generovany z KRA.sk session) |

---

## Zavislosti

- `wcs.streamcinema.SCBrowser` -- browsing API
- `wcs.streamcinema.SCClient` -- autentizace, streamy
- `wcs.kraska.KraskaClient` -- resolve URL
- `wcs.ui.dialogs.DialogWcsSearch` -- dialog pro vyber streamu
- `wcs.metadata.TMDbClient` -- obohaceni metadat (`enrich_with_tmdb`)
