# 008 - MyCinema Dialog

**Status:** COMPLETED
**Vytvoreno:** 2026-02-22
**Updated:** 2026-02-22 23:18
**Soubory:** `wcs/ai/DialogMyCinema.py`, sdileny XML layout s MyTV

---

## Ucel

MyCinema je filmova obdoba MyTV. Umoznuje uzivateli vytvaret vlastni "kina" (kanaly) s filmy misto serialu. Dedi z `MyTVDialog` a prepisuje metody specificke pro filmy -- hero zona, program list, prehravani, statistiky. Sdili XML layout s MyTV (property-driven UI).

---

## Architektura

```
MyCinemaDialog (dedi z MyTVDialog)
       |
       |-- MediaChannelManager(channel_type='cinema')   # Sprava kin
       |-- ChannelHistory(channel_type='cinema')         # Watched status filmu
       |-- DialogAddMedia(media_type='cinema')           # Pridavani filmu
       |-- ChannelNameGenerator(media_type='cinema')     # AI pojmenovani
       |
       v
  Sdileny XML layout (DialogMyTV*.xml)
  Rizeno pres Window Properties (WCS.MediaType='cinema')
```

**Klicovy princip:** MyCinema NEMA vlastni XML soubory. Pouziva stejne DialogMyTV XML varianty (classic, appletv, kodi). Rozdily v UI ridi Python pres `WCS.MediaType` property a cinema-specificke labely.

---

## File Map

### Python

| Soubor | Ucel |
|--------|------|
| [DialogMyCinema.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py) | Hlavni trida `MyCinemaDialog` + factory `show_my_cinema_dialog()` (1302 radku) |
| [DialogMyTV.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py) | Parent trida `MyTVDialog` (4163 radku) |
| [MediaChannelManager.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/MediaChannelManager.py) | Unified sprava kanalu, `channel_type='cinema'` (501 radku) |
| [ChannelHistory.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/ChannelHistory.py) | Historie sledovani -- `mark_movie_watched()`, `is_movie_watched()` (236 radku) |
| [DialogAddMedia.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogAddMedia.py) | Unified dialog pro pridavani medii, `media_type='cinema'` (953 radku) |
| [router.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/router.py#L116-L121) | Akce `my_cinema_dialog` → `show_my_cinema_dialog()` |

### XML (sdilene s MyTV)

| Soubor | Ucel |
|--------|------|
| `ai/DialogMyTV.xml` | Default layout |
| `ai/DialogMyTV_appletv.xml` | AppleTV varianta |
| `ai/DialogMyTV_classic.xml` | Classic varianta |
| `ai/DialogMyTV_kodi.xml` | Kodi varianta |

---

## Vstupni bod

```python
# wcs/ai/DialogMyCinema.py, radek 1280
def show_my_cinema_dialog(addon, show_nav_sidebar=False, nav_position=0)
```

Vybere XML podle `mytv_design` nastaveni, vytvori `MyCinemaDialog`, zavola `doModal()`.

**Router:** `action=my_cinema_dialog` → [router.py:L116-L121](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/router.py#L116-L121)

---

## Klicove overrides oproti MyTVDialog

MyCinemaDialog prepisuje ~18 metod parenta. Zde jsou nejdulezitejsi:

### `__init__()` ([radek 38](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py#L38))

- `self._channel_type = 'cinema'`
- `self.channel_manager = MediaChannelManager(addon, channel_type='cinema')`
- `self._nav_section_id = 'my_cinema'`

### `onInit()` ([radek 49](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py#L49))

Cinema-specificke properties:
- `WCS.MediaType` = `'cinema'` (XML conditional visibility)
- `WCS.Button.Play` = `'Prehrat filmy'`
- `WCS.Button.Delete` = `'Smazat kino'`
- `WCS.Row1.Label` = `'Moje kina'`
- `WCS.Row3.Label` = `'Moje filmy'`
- Pokud neexistuji zadna kina → automaticky otevre `_create_new_channel()`

### `_update_hero_zone()` ([radek 132](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py#L132))

Zobrazuje prvni film z program listu:
- `WCS.MyTV.Hero.SeriesName` = nazev filmu
- `WCS.MyTV.Hero.EpCode` = rok vydani
- `WCS.MyTV.Hero.EpTitle` = tagline filmu
- `WCS.MyTV.Hero.Plot` = popis (max 300 znaku)
- `WCS.MyTV.Hero.MetaLine` = `genre | runtime | year | ★ rating`
- Resume check: `WCS.MyTV.Hero.HasResume` pokud `resume_position > 60s`

### `onClick()` ([radek 298](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py#L298))

| Control ID | Akce |
|------------|------|
| 2000 | Kino vybrano / Vytvorit nove kino |
| 9100 | Grid: film detail nebo pridani filmu |
| 9110 | Prehrat vsechny filmy (broadcast) |
| 9111 | Zamichat program |
| 9112 | Presunout kino |
| 9113 | AI prejmenovat kino |
| 9114 | Smazat kino |
| 9115 | Milionar z gridu (cinema mix mode) |
| 9060 | My Movies list → detail filmu |
| 9040/9042 | Hero zona → prehrat prvni film |
| 9043 | Milionar z hero zony |
| 9000 | Program list → prehrat film / reorder |

### `refresh_program_view()` ([radek 692](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py#L692))

Zjednoduseno oproti MyTV (zadne epizody):
1. Nacte `channel.media_list`
2. Zamichat (`random.shuffle`)
3. Limit 20 filmu
4. Vytvori `ListItem` pres `_create_movie_list_item()`
5. Update hero zone + pozadi

### `_play_program_item()` ([radek 1237](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py#L1237))

1. Oznaci film jako sledovany: `ChannelHistory.mark_movie_watched(channel_id, movie_id)`
2. Zavre dialog
3. Zavola `play_movie_from_addon(meta, addon)` z `wcs.utils`

### `_play_broadcast()` ([radek 1137](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py#L1137))

Vytvori Kodi playlist vsech filmu a spusti prehravani:
- Pouziva plugin URL s akci `play_movie_from_addon_playlist`
- Predava `mycinema_channel_id` pro trackovani

---

## Sprava kin (CRUD)

| Operace | Metoda | Popis |
|---------|--------|-------|
| Create | `_create_new_channel()` L973 | Docasny nazev → AddMedia dialog → AI/genre pojmenovani |
| Read | `refresh_channels_view()` L612 | Control 2000, kazde kino + "Vytvorit" tlacitko |
| Update | `_close_add_series_dialog()` L537 | Po zavreni AddMedia: composite, rename, refresh |
| Delete | `_confirm_delete_channel()` L1205 | Smaze historii + kanal, toast "Kino smazano" |

### Auto-naming flow

1. Novy kanal s docasnym nazvem `"Nove kino N"`
2. Uzivatel prida filmy pres `AddMediaDialog(media_type='cinema')`
3. Po zavreni:
   - **AI mode** → `ChannelNameGenerator.generate_from_genres()` jako temp, pak `_generate_ai_channel_name_async()`
   - **Genre mode** → `ChannelNameGenerator.generate_from_genres(media_list, media_type='cinema')`
4. Pokud 0 filmu → kanal smazan + toast warning

---

## Movie Detail dialog

`_show_movie_detail_dialog()` ([radek 849](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py#L849)) -- znovupouziva UI SeriesDetail:

- `_get_movie_metadata()` ([radek 887](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py#L887)) -- cache + TMDb details API + images API (clearlogo)
- Properties: `WCS.MyTV.SeriesDetail.*` (sdilene s TV)
- Cache TTL: 24h

---

## Millionaire integrace

Dve varianty spusteni:

1. **Z hero zony** (`_play_game_from_home`, L408) -- kontext prvniho filmu, `media_type='movie'`
2. **Z cinema gridu** (`_play_game_from_cinema_grid`, L439) -- kontext vsech filmu v kine, `media_type='channel'`, combined plot

---

## My Movies list

`_populate_my_series_list()` ([radek 231](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py#L231)):

1. Nacte filmy z `user_data.load_tmdb_movies()` ("Moje filmy")
2. Nacte filmy ze vsech kin
3. Deduplikace podle movie ID
4. Control 9060, property `movie_id` + `channel_id`

---

## Zavislosti

- `wcs.ai.DialogMyTV.MyTVDialog` -- parent trida (4163 radku)
- `wcs.ai.MediaChannelManager` -- unified sprava kanalu (`channel_type='cinema'`)
- `wcs.ai.ChannelHistory` -- `mark_movie_watched()`, `is_movie_watched()`, `delete_channel_history()`
- `wcs.ai.DialogAddMedia` -- unified add dialog (`media_type='cinema'`)
- `wcs.ai.ChannelNameGenerator` -- AI/genre pojmenovani kin
- `wcs.caching.get_cache_manager` -- cache pro movie metadata
- `wcs.metadata.TMDbClient` -- TMDb API pro detaily filmu
- `wcs.utils.play_movie_from_addon` -- prehravani filmu
- `wcs.user_data` -- ulozene filmy ("Moje filmy")

### Kdo zavisi na MyCinema

- `wcs/router.py` -- akce `my_cinema_dialog`
- Navigation sidebar -- polozka "MyCinema"

---

## Jak rozsirit

### Pridat novy typ obsahu do kina (napr. dokumenty)

1. Novy filtr v `_populate_my_series_list()` -- pridej zdroj
2. `_create_movie_list_item()` -- nastav properties pro novy typ
3. XML: pouzij `WCS.MediaType` pro conditional visibility

### Pridat novou akci do gridu

1. Pridej control ID do `onClick()` v `DialogMyCinema.py`
2. Implementuj handler metodu
3. XML: pridej tlacitko s unikatnim ID do grid layoutu

### Zmenit chovani prehravani

1. `_play_program_item()` -- single film playback
2. `_play_broadcast()` -- playlist playback
3. `_play_hero_movie()` -- hero zona deleguje na `_play_program_item()`
