# 007f - Series Detail (MyTV AppleTV Inline Dialog)

**Status:** COMPLETED
**Updated:** 2026-02-22 23:35
**XML:** `DialogMyTV_appletv.xml` [L2466-2918](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/resources/skins/Default/1080i/ai/DialogMyTV_appletv.xml#L2466-L2918)
**Python:** `DialogMyTV.py` [L2965-3100](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L2965-L3100) + [L3448-3500](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L3448-L3500)

---

## Ucel

Detail serialu po kliknuti na poster v Series Grid (9100) nebo My Series listu (9060). Zobrazuje metadata, poster, clearlogo, fanart a tlacitko pro odebreni serialu z kanalu.

---

## Aktivace

- **Trigger:** klik na serial v gridu 9100 nebo v My Series listu 9060
- **Metoda:** [_show_series_detail_dialog(series_id, channel_id, return_focus_id)](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L2969)
- **Property:** `WCS.MyTV.SeriesDetail.Active` = `true`
- **Zavreni:** ESC/Back → [_close_series_detail_dialog()](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L3083)

---

## Metadata loading

[_get_series_metadata(series_id, series_data)](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L3007):

1. Cache check (`series_detail_{id}`, TTL 7 dni)
2. TMDb API: GET `/tv/{id}?language=cs-CZ` → name, plot, rating, genres, year, fanart
3. TMDb API: GET `/tv/{id}/images` → clearlogo (en/cs priority)
4. Cache set (7 dni)

---

## Control ID mapa

| ID | Typ | Ucel |
|----|-----|------|
| 9300 | button | Odebrat seriál z kanálu → delete confirmation |
| 9305 | button | Potvrdit odebrání (cervena) |
| 9306 | button | Zrušit odebrání |

### Delete Series Confirmation

Property: `WCS.MyTV.DeleteSeriesConfirm` = `true`.
- `_show_delete_series_confirmation()` [L1586](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1586)
- `_confirm_delete_series()` [L1596](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1596) → `toggle_series_in_channel()` + refresh
- `_cancel_delete_series_confirmation()` [L1591](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1591)

---

## Window Properties

| Property | Popis |
|----------|-------|
| `WCS.MyTV.SeriesDetail.Active` | `true` = dialog viditeln |
| `WCS.MyTV.SeriesDetail.Name` | Nazev serialu |
| `WCS.MyTV.SeriesDetail.Year` | Rok |
| `WCS.MyTV.SeriesDetail.Genre` | Zanry (max 3) |
| `WCS.MyTV.SeriesDetail.Rating` | Rating (napr. "8.1") |
| `WCS.MyTV.SeriesDetail.Plot` | Popis |
| `WCS.MyTV.SeriesDetail.Fanart` | Fanart URL |
| `WCS.MyTV.SeriesDetail.Logo` | Clearlogo URL |
| `WCS.MyTV.SeriesDetail.Poster` | Poster URL |
| `WCS.MyTV.DeleteSeriesConfirm` | `true` = delete potvrzeni |

---

## Event delegace

| Event | Host metoda | Radek |
|-------|-------------|-------|
| onAction | `_handle_series_detail_action()` | [L3448](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L3448) |
| onClick | `_handle_series_detail_click()` | [L3467](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L3467) |
| Guard | `_is_series_detail_dialog_active()` | [L3099](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L3099) |

---

## Post-removal flow

`_close_series_detail_dialog(removed=True)` [L3083](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L3083):
1. `generate_channel_composite()` -- aktualizuje ikonu kanalu
2. `update_editor_view()` -- obnovi grid
3. `refresh_program_view(shuffle=True)` -- obnovi program
4. `refresh_channels_view(set_focus=False)` -- obnovi channel list
5. Focus → `return_focus_id` (9100 nebo 9060)

---

## Zavislosti

- TMDb API -- detaily serialu + images (clearlogo)
- `CacheManager` -- cache metadat (7 dni)
- `MediaChannelManager` -- `toggle_series_in_channel()`, `generate_channel_composite()`
- Series Grid (007b) -- navrat po zavreni
