# 007e - Edit Progress (MyTV AppleTV Inline Dialog)

**Status:** COMPLETED
**Updated:** 2026-02-22 23:35
**XML:** `DialogMyTV_appletv.xml` [L3488+](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/resources/skins/Default/1080i/ai/DialogMyTV_appletv.xml#L3488)
**Python:** `DialogMyTV.py` [L1883-2259](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1883-L2259)

---

## Ucel

Editace postupu sledovani serialu. Zobrazi sezony a epizody z TMDb, uzivatel klikne na epizodu = nastaveni "next to watch". Automaticky aktualizuje program list.

---

## Aktivace

- **Trigger:** tlacitko "Upravit postup" (9026) v Play Selection dialogu
- **Metoda:** [_show_edit_progress_dialog()](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1887)
- **Property:** `WCS.MyTV.EditProgress` = `true`
- **Zavreni:** ESC/Back nebo tlacitko 9420 → [_hide_edit_progress_dialog()](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1928)

---

## Async data loading

[_load_edit_progress_data(tmdb_id, channel_id)](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1971) bezi v background threadu:

1. TMDb API: GET `/tv/{tmdb_id}` → sezony
2. Filtruje specials (season 0), max 10 sezon
3. Pro kazdou sezonu: GET `/tv/{tmdb_id}/season/{n}` → epizody
4. Nacte aktualni progress z `ProgressManager.get_progress()`
5. Naplni list controls 9401-9410 s dimming pro sledovane epizody

---

## Control ID mapa

| ID | Typ | Ucel |
|----|-----|------|
| 9401-9410 | list | Sezony 1-10 (kazda = horizontalni list epizod) |
| 9420 | button | Zavreni dialogu |

### Scrollovani sezon

Maximalne 4 sezony viditelne najednou. Property `WCS.EditProgress.Season{N}.Show` ridi viditelnost.

[_update_visible_seasons(focused_season_idx)](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1955):
- Sleduje focus na 9401-9410 pres `onFocus()` [L1253](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1253)
- Pocita `first = max(0, min(focused - 1, total - 4))`
- Property `WCS.EditProgress.ScrollRow` = offset

---

## Episode item properties

Kazda epizoda v listu ma:

| Property | Popis |
|----------|-------|
| `season_num` | Cislo sezony |
| `episode_num` | Cislo epizody |
| `episode_title` | Nazev epizody |
| `dimcolor` | `50FFFFFF` (sledovane) / `FFFFFFFF` (nessledovane) |
| `textcolor` | `60FFFFFF` / `BBFFFFFF` |
| `is_current` | `true` = aktualni (next to watch) |

---

## onClick logika

[_handle_edit_progress_click()](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L2119):

1. Klik na epizodu = "toto je dalsi k sledovani"
2. Prepocet: `episode > 1` → progress = (season, episode-1)
3. `ProgressManager.update_progress(channel_id, tmdb_id, season, episode)`
4. `ProgressManager.invalidate_program_cache()` -- zneplatni cache
5. `refresh_program_view()` -- obnovi program list
6. Vytvori novy `ListItem` pro Play Selection s novymi daty
7. Toast "Postup nastaven: S01E05"

---

## Window Properties

| Property | Popis |
|----------|-------|
| `WCS.MyTV.EditProgress` | `true` = dialog viditeln |
| `WCS.EditProgress.SeriesName` | Nazev serialu |
| `WCS.EditProgress.Loading` | `true` = nacitani dat |
| `WCS.EditProgress.ScrollRow` | Offset scrollu sezon (0-based) |
| `WCS.EditProgress.SeasonCount` | Celkovy pocet sezon |
| `WCS.EditProgress.Season{N}.Label` | Label sezony (napr. "Sezóna 1 (10 dílů)") |
| `WCS.EditProgress.Season{N}.Show` | `true` = tato sezona viditelna |

---

## Zavislosti

- `ProgressManager` -- `get_progress()`, `update_progress()`, `invalidate_program_cache()`
- TMDb API -- sezony a epizody (`/tv/{id}`, `/tv/{id}/season/{n}`)
- `ChannelHistory` -- resume points
- Play Selection dialog (007d) -- navrat po zavreni
