# 007c - Add Media Dialog (MyTV AppleTV Inline Dialog)

**Status:** COMPLETED
**Updated:** 2026-02-22 23:35
**XML:** `DialogMyTV_appletv.xml` [L1571-2465](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/resources/skins/Default/1080i/ai/DialogMyTV_appletv.xml#L1571-L2465)
**Python controller:** `DialogAddMedia.py` [953ř](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogAddMedia.py)
**Python integrace:** `DialogMyTV.py` [L2852-2963](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L2852-L2963)

---

## Ucel

Dialog pro pridavani serialu/filmu do kanalu/kina. Vyhledava v TMDb, zobrazuje vysledky s postery, umoznuje pridavat/odebirat serialy z kanalu jednoduchym kliknutim.

---

## Aktivace

- **Trigger:** klik na "+" polozku v Series Grid (9100) nebo `_create_new_channel()`
- **Metoda:** [_show_add_series_dialog()](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L2852)
- **Property:** `WCS.MyTV.AddDialog.Active` (neprazdne)
- **Zavreni:** ESC/Back → [_close_add_series_dialog()](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L2868)

---

## Architektura (Controller pattern)

```
DialogMyTV.py (host)
    _show_add_series_dialog() → create_add_media_controller()
    _handle_add_series_click() → controller.onClick()
    _handle_add_series_action() → controller.onAction()
    _handle_add_series_focus() → controller.onFocus()
    _close_add_series_dialog() → controller.hide()
        |
        v
DialogAddMedia.py (controller, 953ř)
    - Spravuje hledani, vysledky, toggle serialu
    - Nastavuje window properties na parent dialog
    - Pouziva media_type='tv' (MyTV) nebo 'cinema' (MyCinema)
```

Controller je **nezavisly objekt** -- ne dialog. Pouziva `setProperty()`/`clearProperty()` na parent dialogu pro UI update, deleguje onClick/onAction/onFocus.

---

## Klicove features

1. **TMDb hledani** -- vyhledava serialy/filmy pres TMDb API
2. **Toggle logika** -- klik na serial ho prida/odebere z kanalu (checkmark)
3. **Auto-naming** -- po zavreni: genre-based nebo AI pojmenovani kanalu
4. **Channel composite** -- generovani compositu z posteru serialu
5. **Empty channel cleanup** -- prazdny novy kanal se automaticky smaze

---

## Delegace eventu (host → controller)

| Event | Host metoda | Controller metoda |
|-------|-------------|-------------------|
| onClick | `_handle_add_series_click(controlId)` | `controller.onClick(controlId)` |
| onAction | `_handle_add_series_action(action)` | `controller.onAction(action)` |
| onFocus | `_handle_add_series_focus(controlId)` | `controller.onFocus(controlId)` |

Controller vraci `True` pokud event zpracoval. Po zavreni (ESC) host vola `_close_add_series_dialog()`.

---

## Post-close flow

[_close_add_series_dialog()](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L2868-L2932):

1. Zkontroluje `_pending_new_channel_id` (novy kanal?)
2. Pokud ano a prazdny → smaze kanal + toast "nebyl vytvořen"
3. Pokud ano a ma serialy → auto-naming:
   - AI mode → `_generate_ai_channel_name_async()` (background thread)
   - Genre mode → `generate_from_genres()` (sync)
4. Regeneruje composite ikonu
5. Refresh channels + program
6. Focus → 9100 (grid) nebo 2000 (channel list)

---

## Window Properties

| Property | Popis |
|----------|-------|
| `WCS.MyTV.AddDialog.Active` | Neprazdne = dialog viditeln |

Ostatni properties spravuje controller primo na parent dialogu (search results, selected items, etc.).

---

## Zavislosti

- `DialogAddMedia.py` (953ř) -- controller logika, TMDb hledani
- `MediaChannelManager` -- `toggle_series_in_channel()`, `generate_channel_composite()`
- `ChannelNameGenerator` -- AI/genre pojmenovani
- `TMDbClient` -- vyhledavani serialu/filmu
