# 007b - Series Grid (MyTV AppleTV Inline Dialog)

**Status:** COMPLETED
**Updated:** 2026-02-22 23:35
**XML:** `DialogMyTV_appletv.xml` [L1186-1569](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/resources/skins/Default/1080i/ai/DialogMyTV_appletv.xml#L1186-L1569)
**Python:** `DialogMyTV.py` [L1267-1584](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1267-L1584)

---

## Ucel

Sprava serialu v kanalu. Po kliknuti na kanal v channel listu (2000) se otevre overlay s poster gridem vsech serialu v kanalu + akcni tlacitka pro spravu kanalu.

---

## Aktivace

- **Trigger:** klik na polozku v channel listu 2000 (pokud neni `is_create_button`)
- **Metoda:** [_show_series_grid_dialog()](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1298)
- **Property:** `WCS.MyTV.SeriesGrid` = `true`
- **Zavreni:** ESC/Back nebo [_close_series_grid_dialog()](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py#L1162)

---

## XML Layout

**Panel:** 1600x720 na pozici 160,180. Background `dialog_rounded_large.png` s `colordiffuse F01A1A1A`.

### Vizualni struktura

```
+--TITLE: $WCS.MyTV.SeriesGrid.Title--------+
| Subtitle: "Správa seriálů v kanálu"        |
|                                            |
| [Přehrát kanál][Zamíchat][Milionář]        |
| [Název od AI ✨][Odebrat kanál]            |
|                                            |
| [Poster1][Poster2][Poster3][Poster4]...    |
| [name]   [name]   [name]   [+Přidat]      |
+--------------------------------------------+
```

### Control ID mapa

| ID | Typ | Ucel | Barva focus |
|----|-----|------|-------------|
| 9100 | panel | Poster grid (195x320 polozky, scrollovatelny) | zoom 112% |
| 9110 | button | Přehrát kanál | Modra `CC2997FF` |
| 9111 | button | Zamíchat program | Seda `BB666666` |
| 9115 | button | Milionář (channel mix) | Zlata `CCFFB800` |
| 9113 | button | Název od AI | Fialova `FFBF5AF2` + sparkle ikona |
| 9114 | button | Odebrat kanál | Cervena `FFFF453A` |
| 9006 | button | Potvrdit smazání | Cervena `FFFF3B30` |
| 9007 | button | Zrušit smazání | Seda `80404858` |

### Delete Confirmation (inline)

Visibility: `WCS.MyTV.DeleteConfirm == true` (nahrazuje action row).
Text: `$WCS.Button.DeleteConfirm`, Cancel (9007) + Confirm (9006).

### Poster grid (9100)

- Polozky: 195x320 (poster 175x262 + name label)
- Diffuse maska: `card_mask.png` pro zakulacene rohy
- Focused: zoom 112%, jasnejsi text
- Posledni polozka: `is_add_button == true` → otevre Add Media dialog
- Fallback poster: `placeholder_tv_card.png`

---

## Focus navigace

```
Action buttons: 9110 → 9111 → 9115 → 9113 → 9114
                  ↓       ↓       ↓       ↓       ↓
Poster grid:    ←←←←←←← 9100 →→→→→→→→→
                  ↑ (onup = 9110)
```

Delete confirm: `9007 ↔ 9006` (trap -- onup/ondown = self)

---

## onClick routing (Python)

| Control | Metoda | Popis |
|---------|--------|-------|
| 9100 | `_handle_grid_click()` | Klik na serial → Series Detail, klik na "+" → Add Media |
| 9110 | `_play_broadcast()` | Zavre grid, spusti playlist |
| 9111 | `refresh_program_view(shuffle=True)` | Zamichani programu |
| 9113 | `_regenerate_channel_name_from_grid()` | AI prejmenuje kanal |
| 9114 | `_show_delete_confirmation()` | Inline delete potvrzeni |
| 9115 | `_show_game_dialog(media_type='channel')` | Milionar (combined plot) |
| 9006 | `_confirm_delete_channel()` | Smaze kanal + historii |
| 9007 | `_cancel_delete_confirmation()` | Zrusi potvrzeni, focus → 9114 |

---

## Window Properties

| Property | Popis |
|----------|-------|
| `WCS.MyTV.SeriesGrid` | `true` = dialog viditeln |
| `WCS.MyTV.SeriesGrid.Title` | Nazev kanalu (titulek) |
| `WCS.MyTV.DeleteConfirm` | `true` = delete potvrzeni viditelne |
| `WCS.Button.DeleteConfirm` | Text delete varování |

---

## Zavislosti

- `MediaChannelManager` -- CRUD kanalu, `generate_channel_composite()`
- `ChannelHistory` -- `delete_channel_history()`
- `ChannelNameGenerator` -- AI/genre pojmenovani
- `MillionaireMyTVAdapter` -- Milionar z gridu (channel mix mode)
- `DialogAddMedia` -- pridavani serialu (posledni polozka v gridu)
- Sub-dialogy: Series Detail (007f), Delete Confirmation (inline)
