# 007a - MyTV AppleTV Layout

**Status:** COMPLETED
**Updated:** 2026-02-22 23:21
**XML:** `resources/skins/Default/1080i/ai/DialogMyTV_appletv.xml` (4666 radku)
**Python:** `wcs/ai/DialogMyTV.py` (4163 radku)

---

## Ucel

AppleTV styl je hlavni layout pro MyTV/MyCinema. Inspirovany Apple TV+ -- fullscreen hero zona s fanart, horizontalni scrollovaci rows, cinematic gradienty, inline sub-dialogy.

---

## Hlavni layout

XML soubor: [DialogMyTV_appletv.xml](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/resources/skins/Default/1080i/ai/DialogMyTV_appletv.xml)

### Vizualni struktura

```
+--------------------------------------------------+
| HERO ZONE (fullscreen fanart, zoom animace)      |
| gradient_cinematic_bottom + gradient_top_header  |
|                                                   |
|  [Logo/Nazev]    Title+Stats    Clock+Date       |
|  [EpCode EpTitle]                                |
|  [MetaLine]                                      |
|  [Plot - jen pri focusu 9042]                    |
+--------------------------------------------------+
| ROW 0: ACTION BUTTONS (9004, 9040, 9041, 9043)  |
+--------------------------------------------------+
| ROW 1: MOJE KANALY (list 2000, horizontal)       |
|  [Poster] [Poster] [Poster] [+Novy]              |
+--------------------------------------------------+
| ROW 2: PROGRAM (list 9000, horizontal 16:9 cards)|
|  [Still+Logo] [Still+Logo] [Still+Logo]          |
+--------------------------------------------------+
| ROW 3: MOJE SERIALY (list 9060, horizontal)      |
|  [Poster] [Poster] [Poster]                      |
+--------------------------------------------------+
```

### Scroll mechanismus

Celý content (ROW 0-3) je v jedné skupině s conditional slide animacemi:

| Focus | Content posun | Gradient posun |
|-------|--------------|----------------|
| Action buttons (9099) | 0 | 0 |
| Channels (2000) | -330px | -800px |
| Program (9000) | -820px | -2000px |
| My Series (9060) | -1120px | -3500px |

Gradient se pohybuje 2.5-3x rychleji nez obsah → exponencialni parallax.

---

## Control ID mapa

### Hlavni obrazovka

| ID | Typ | Umisteni | Ucel |
|----|-----|----------|------|
| 9042 | button | Hero zona | Neviditelny focusable button (klik = prehraj) |
| 9004 | button | ROW 0 | Spustit vysilani (primary, `CC2997FF`) |
| 9040 | button | ROW 0 | Prehrat epizodu/film |
| 9041 | button | ROW 0 | Prehrat serial (**skryty v cinema mode**) |
| 9043 | button | ROW 0 | Milionar (`CCFFB800` zluta) |
| 9099 | grouplist | ROW 0 | Container pro action buttons |
| 2000 | list | ROW 1 | Kanaly (horizontal, poster 210x315) |
| 9000 | list | ROW 2 | Program (horizontal, still 290x163 16:9) |
| 9060 | list | ROW 3 | Moje serialy (horizontal, poster 198x297) |

### Sidebar

| ID | Typ | Ucel |
|----|-----|------|
| 7000 | group | Sidebar container (450px wide, slide -450px) |
| 7100 | list | Navigacni polozky |
| 7200 | list | Horizontal icon bar |

---

## Focus navigace

```
9042 (hero) → ondown=noop (buttons se zobrazi pres scroll)

9004 → onup=9042, ondown=2000, onright=9040
9040 → onup=9042, ondown=2000, onleft=9004, onright=9041
9041 → onup=9042, ondown=2000, onleft=9040, onright=9043  (hidden v cinema)
9043 → onup=9042, ondown=2000, onleft=9041

2000 → onup=noop, ondown=9000
9000 → onup=2000, ondown=9060
9060 → onup=9000, ondown=noop
```

---

## Window Properties (Python → XML)

### Hero zona

| Property | Popis |
|----------|-------|
| `WCS.MyTV.Hero.SeriesName` | Nazev serialu/filmu |
| `WCS.MyTV.Hero.SeriesLogo` | Clearlogo (pokud existuje, skryje nazev) |
| `WCS.MyTV.Hero.EpCode` | S01E02 / rok |
| `WCS.MyTV.Hero.EpTitle` | Nazev epizody / tagline |
| `WCS.MyTV.Hero.MetaLine` | `genre | runtime | ★ rating` |
| `WCS.MyTV.Hero.Plot` | Plot (max 300 znaku, viditelny jen pri focusu 9042) |
| `WCS.MyTV.Hero.Fanart` | Fullscreen pozadi |
| `WCS.MyTV.Hero.HasResume` | Zmeni label 9040 na "Pokracovat" |

### Obecne

| Property | Popis |
|----------|-------|
| `WCS.AIChat.Title` | Titulek vlevo nahore |
| `WCS.Channel.GlobalStats` | Statistiky "X kanalu · Y serialu" |
| `WCS.MediaType` | `cinema` → skryje 9041, zmeni labely |
| `WCS.Button.Play/PlayEp/Delete/DeleteConfirm` | Dynamicke button labely |
| `WCS.Row1.Label` / `WCS.Row3.Label` | Row nadpisy |

### Reorder mode

| Property | Popis |
|----------|-------|
| `WCS.MyTV.ReorderMode` | Aktivni → zmeni ROW 1 header, modry border na kartach |
| `WCS.MyTV.ReorderName` | Nazev presunuvaneho kanalu |
| `WCS.MyTV.ProgramReorderMode` | Program reorder |
| `WCS.MyTV.ProgramReorderName` | Nazev presunuvane polozky |

---

## ListItem Properties (program list 9000)

| Property | Popis |
|----------|-------|
| `ep_code` | S01E02 / rok |
| `episode_title` | Nazev epizody / tagline |
| `series_logo` | Logo serialu (overlay na stillu) |
| `watched` | `true` → "watched" indikator |
| `is_resume` | `true` → progress bar |
| `resume_width` | Sirka progress baru v px |
| `movie_id` / `channel_id` | ID pro playback |

---

# INLINE SUB-DIALOGY

Vsechny sub-dialogy jsou soucast jednoho XML souboru. Zobrazuji se pres dim overlay + floating panel,
rizene window properties.

---

## 1. Series Grid (sprava serialu v kanale)

**Visibility:** `WCS.MyTV.SeriesGrid` (neprazdne)
**XML radky:** [L1186-1569](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/resources/skins/Default/1080i/ai/DialogMyTV_appletv.xml#L1186-L1569)
**Python:** `_show_series_grid_dialog()`, `_close_series_grid_dialog()`

### Layout

- Dim overlay `70000000`
- Panel 1600x720 (pozice 160,180) se zaoblenymi rohy (`dialog_rounded_large.png`)
- Titulek: `WCS.MyTV.SeriesGrid.Title` (nazev kanalu)
- Subtitle: "Sprava serialu v kanalu"

### Action buttons (hore)

| ID | Label | Barva focus | Akce |
|----|-------|-------------|------|
| 9110 | Prehrat kanal | `CC2997FF` modra | `_play_broadcast()` |
| 9111 | Zamichat program | `BB666666` seda | `refresh_program_view()` |
| 9115 | Milionar | `CCFFB800` zluta | `_play_game_from_cinema_grid()` |
| 9113 | Nazev od AI | `FFBF5AF2` fialova | `_regenerate_channel_name_from_grid()` |
| 9114 | Odebrat kanal | `FFFF453A` cervena | `_show_delete_confirmation()` |

### Delete Confirmation (inline nahrazeni buttons)

- Visibility: `WCS.MyTV.DeleteConfirm == true`
- Full-width bar (`1a2535` tmave modra)
- Text: `WCS.Button.DeleteConfirm` vlevo
- 9007 = Zrusit (seda), 9006 = Odebrat (cervena `FFFF3B30`)
- Focus trapped: oba self-reference v navigation

### Series/Movie grid (panel 9100)

- Pozice: 20,220, velikost 1560x490
- Panel layout: poster karty 175x262 se zoom 112% na focus
- Posledni item = "Pridat serial/film" card (`is_add_button`)
- onup → 9110 (action buttons)

---

## 2. Add Media Dialog (pridavani serialu/filmu)

**Visibility:** `WCS.MyTV.AddDialog.Active` (neprazdne)
**XML radky:** [L1571-2400+](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/resources/skins/Default/1080i/ai/DialogMyTV_appletv.xml#L1571-L2440)
**Python:** `DialogAddMedia.py` (953 radku), `_show_add_series_dialog()`, `_close_add_series_dialog()`

### 3 stavy

#### Stav 1: Vyber zdroje (prazdne `WCS.MyTV.AddDialog.ListingMode`)

4 action karty (340x200 kazda):

| ID | Label | Ikona |
|----|-------|-------|
| 9201 | Z moji knihovny | `card_my_library.png` |
| 9202 | Vyhledat na TMDb | `card_search_tmdb.png` |
| 9203 | Doporucit z TMDb | `card_tmdb_recommend.png` |
| 9204 | Doporucit od AI | `card_ai_recommend.png` |

Dynamicky popis dole: `WCS.MyTV.AddDialog.Description`
TV/Cinema rozliseni pres `WCS.MediaType` (titulek "Pridat serial" vs "Pridat film")

#### Stav 2: Listing medii (neprazdne `WCS.MyTV.AddDialog.ListingMode`)

- Titulek: `WCS.MyTV.AddDialog.ListingTitle`
- Wraplist 9211 (vlevo, 900px): postery serialu/filmu se checkmark pro pridane (`is_added`)
- Metadata panel (vpravo, 580px): fanart, titulek, rok+zanr, rating, plot
- Action buttons list 9220 (dole, horizontal): "Pridat", "Moje serialy", "Podobne", "Milionar"
- Hint: "Stiskni ENTER pro zobrazeni moznosti"
- Visibility actions: `WCS.MyTV.AddDialog.ActionsVisible`

#### Stav 3: AI Loading (neprazdne `WCS.MyTV.AddDialog.AILoading`)

Matrix efekt: sken linie, glitch text (`WCS.MyTV.AddDialog.GlitchText`), animated dots,
status (`WCS.MyTV.AddDialog.AIStatus`), fun status (`WCS.MyTV.AddDialog.FunStatus`).

---

## 3. Series Detail (detail serialu)

**Visibility:** `WCS.MyTV.SeriesDetail.Active` (neprazdne)
**Python:** `_show_series_detail_dialog()`, `_handle_series_detail_click()`

### Properties

| Property | Popis |
|----------|-------|
| `WCS.MyTV.SeriesDetail.Name` | Nazev |
| `WCS.MyTV.SeriesDetail.Year` | Rok |
| `WCS.MyTV.SeriesDetail.Genre` | Zanry |
| `WCS.MyTV.SeriesDetail.Rating` | Hodnoceni |
| `WCS.MyTV.SeriesDetail.Plot` | Popis |
| `WCS.MyTV.SeriesDetail.Fanart` | Pozadi |
| `WCS.MyTV.SeriesDetail.Logo` | Clearlogo |
| `WCS.MyTV.SeriesDetail.Poster` | Poster |

### Controls

- 9300 = Odebrat z kanalu (button)
- 9301 = Zavrit detail (button)
- Pouziva se i pro MyCinema (movie detail sdili stejne properties)

---

## 4. Modal Card / Play Selection (vyber prehravani)

**Visibility:** `WCS.MyTV.PlaySelection == true`
**Python:** `_show_play_selection()`, scroll lock `WCS.MyTV.PlaySelection.ScrollLock`

### Layout

Floating panel na pozici programu s moznostmi:

| ID | Label (TV) | Popis |
|----|-----------|-------|
| 9020 | Prehrat epizodu | Single epizoda |
| 9021 | Prehrat serial | Jen epizody tohoto serialu |
| 9022 | Prehrat od teto pozice | Od kurzoru + generuje dalsi |
| 9023 | Zamichat kanal | Shuffle program |

Info box 9024: metadata vybrane epizody (nazev, plot, runtime).
Scroll lock drzi pozici na ROW 2.

---

## 5. Edit Progress (uprava progress sledovani)

**Visibility:** `WCS.MyTV.EditProgress.Active` (neprazdne)
**Python:** `_show_edit_progress_dialog()`, `_handle_edit_progress_click()`

### Layout

Panel pro manualni upravu sezony/epizody:

| ID | Ucel |
|----|------|
| 9400 | Sezona - / + |
| 9401 | Epizoda - / + |
| 9402 | Ulozit |
| 9403 | Zrusit |

Properties: `WCS.MyTV.EditProgress.Season`, `WCS.MyTV.EditProgress.Episode`,
`WCS.MyTV.EditProgress.SeriesName`

---

## 6. Game Dialog (Milionar)

**Visibility:** `WCS.MyTV.GameActive == true`
**Python:** `_show_game_dialog()`, `_handle_game_click()`

Fullscreen overlay pro Milionar kviz. Rizeno z `media_type` parametru:
- `movie` = kontext jednoho filmu
- `channel` = kontext vsech serialu/filmu v kanale

---

## 7. Toast Notifikace

**Visibility:** `WCS.MyTV.Toast.Visible == true`
**Python:** `_show_toast(message, type)`

Pravy horni roh, typy: `info`, `success`, `warning`, `error`.
Vzhled: pill background (`btn_rounded_dialog.png`), automaticky zmizi po 3s.

---

## Jak rozsirit

### Pridat novy inline sub-dialog

1. **XML**: Pridat `<control type="group">` s `<visible>` na novou property
2. **Dim overlay**: Pouzit vzor z Series Grid (dim `70000000`)
3. **Panel**: 1600x720 se `dialog_rounded_large.png`, pozice 160,180
4. **Animace**: zoom 90→100 + fade 0→100 pro otevreni, obracene pro zavreni
5. **Python**: `_show_X_dialog()` nastavi property, `_close_X_dialog()` clearuje
6. **Focus trap**: ESC/BACK v `onAction()` deleguje do close metody

### Pridat novy button do action buttons ROW 0

1. Pridat `<control type="group">` do grouplist 9099
2. Button + ring nofocus + ring focus (3-vrstva vzor)
3. Pridat handler do `onClick()` v Python
4. Navigace: onleft/onright na sousedni buttony
