# 007 - MyTV / MyCinema -- Prehled

**Status:** COMPLETED
**Updated:** 2026-02-22 23:19

---

## Ucel

MyTV a MyCinema jsou hlavni televizni rozhrani addonu. MyTV umoznuje vytvaret kanaly ze serialu,
MyCinema z filmu. Oba sdili stejnou architekturu, XML layouty a logiku -- MyCinema dedi z MyTVDialog.

---

## 4 styly dialogu

Uzivatel si vybira v nastaveni (`mytv_design`):

| ID | Styl | XML soubor | Popis |
|----|------|-----------|-------|
| 0 | Classic | `DialogMyTV_classic.xml` | Jednoduchy layout, series grid vlevo + program vpravo |
| 1 | Default | `DialogMyTV.xml` | Zakladni layout |
| 2 | **AppleTV** | `DialogMyTV_appletv.xml` | Hlavni styl -- hero zona, horizontalni rows, scroll animace |
| 3 | Kodi | `DialogMyTV_kodi.xml` | Kodi-native styl |

> **Detailni dokumentace pro AppleTV styl:** [007a-mytv-appletv.md](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/docs/features/007a-mytv-appletv.md)
> **MyCinema dokumentace:** [008-mycinema-dialog.md](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/docs/features/008-mycinema-dialog.md)

---

## Sdilena architektura (vsechny styly)

```
MyTVDialog (wcs/ai/DialogMyTV.py, 4163 radku)
    |-- MediaChannelManager (sprava kanalu, composite ikony)
    |-- ChannelHistory (per-channel JSON historie, resume pointy)
    |-- ProgressManager (sprava progress sledovani)
    |-- PlaylistBuilder (sestavovani playlistu)
    |-- DialogAddMedia (unified dialog pridavani serialu/filmu)
    |-- DialogAIChatRecommendation (AI doporuceni)
    |-- TMDb API + CacheManager
    |
    v
MyCinemaDialog (wcs/ai/DialogMyCinema.py, 1302 radku) -- dedi z MyTVDialog
```

### Sdilena Python logika

| Soubor | Radku | Ucel |
|--------|-------|------|
| [DialogMyTV.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py) | 4163 | Hlavni trida `MyTVDialog` |
| [DialogMyCinema.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyCinema.py) | 1302 | `MyCinemaDialog` (dedi z MyTVDialog) |
| [MediaChannelManager.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/MediaChannelManager.py) | 501 | Unified sprava kanalu TV i Cinema |
| [ChannelHistory.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/ChannelHistory.py) | 236 | Historie + resume per kanal |
| [DialogAddMedia.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogAddMedia.py) | 953 | Unified dialog pridavani medii |
| [ProgressManager.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/ProgressManager.py) | - | Sprava progress sledovani |
| [PlaylistBuilder.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/PlaylistBuilder.py) | - | Sestavovani Kodi playlistu |

---

## Zakladni principy (vsechny styly)

1. **Kanaly** -- uzivatel vytvori kanal, prida serialy/filmy
2. **Program** -- automaticky generovany seznam epizod/filmu podle historie
3. **Prehravani** -- vysilani (playlist), single epizoda/film, serial-only
4. **Historie** -- per-channel JSON, season/episode progress, resume pointy
5. **Sub-dialogy** -- pridavani serialu, detail serialu, vyber prehravani, smazani, hra

---

## Router integrace

| Akce | Cil |
|------|-----|
| `my_tv_dialog` | `show_my_tv_dialog()` → `MyTVDialog` |
| `my_cinema_dialog` | `show_my_cinema_dialog()` → `MyCinemaDialog` |

---

## Nastaveni

| Setting ID | Popis |
|------------|-------|
| `mytv_design` | Styl dialogu (0-3) |
| `mytv_background_mode` | Rezim pozadi (6 moznosti) |
| `mytv_background_dim` | Ztmaveni (0-90%) |
| `mytv_background_animation` | Ken Burns animace |
| `mytv_anim_style` | Styl animace (5 moznosti) |
| `mytv_channel_naming` | Pojmenovani kanalu (AI/genre) |
