---
description: Test TMDb API -- search, metadata, images, logos, episodes. Self-correcting diagnostic workflow.
---

# /test-tmdb

Universal TMDb API testing workflow. Tests any TMDb functionality via curl.
Self-correcting: if the workflow itself has an issue, fix it immediately.
After testing, propose fixes for any project code issues found.

## Prerequisites

- TMDb API key: `d5b6f13a40578d98ec7b8f23c3306a18`
- Base URL: `https://api.themoviedb.org/3`

## Workflow Steps

### 1. Determine test target

Ask what to test (series name, movie, specific endpoint).
If debugging a specific issue, note the expected vs actual behavior.

### 2. Search TMDb for the target

// turbo
```
curl -s "https://api.themoviedb.org/3/search/tv?api_key=d5b6f13a40578d98ec7b8f23c3306a18&query=SERIES_NAME&language=cs-CZ" | python3 -m json.tool | head -40
```

Replace `SERIES_NAME` with URL-encoded series name.
Extract `id` from results. If not found, try `language=en-US`.

### 3. Fetch series details

// turbo
```
curl -s "https://api.themoviedb.org/3/tv/SERIES_ID?api_key=d5b6f13a40578d98ec7b8f23c3306a18&language=cs-CZ" | python3 -m json.tool | head -60
```

Check: name, number_of_seasons, genres, overview, first_air_date.

### 4. Fetch series images (logos, posters, backdrops)

// turbo
```
curl -s "https://api.themoviedb.org/3/tv/SERIES_ID/images?api_key=d5b6f13a40578d98ec7b8f23c3306a18" | python3 -m json.tool
```

Check `logos` array -- look for entries with `iso_639_1` matching desired language (cs, en, null).
If logos exist, note `file_path` and construct URL: `https://image.tmdb.org/t/p/w300{file_path}`

### 5. Fetch episode details (optional)

// turbo
```
curl -s "https://api.themoviedb.org/3/tv/SERIES_ID/season/SEASON/episode/EPISODE?api_key=d5b6f13a40578d98ec7b8f23c3306a18&language=cs-CZ" | python3 -m json.tool | head -30
```

### 6. Analyze results

Compare TMDb API response with what the project code does:
- Read relevant code (e.g., `wcs/metadata/TMDbClient.py`) to understand how data is fetched
- Identify discrepancies between API data and code behavior
- Check language filtering, fallback logic, URL construction

### 7. Propose and implement fix

If a code issue is found:
1. Describe the root cause
2. Show the fix
3. Implement after user approval (or immediately if obvious bug)

If the workflow itself had an issue, fix this workflow file immediately.

## Future TODO

- Python test script for batch testing
- Integration with tmdb-simple library
