---
description: Run end-to-end Millionaire game test with real API calls outside Kodi
---
# /test-game

Runs the complete Millionaire game flow outside Kodi using production prompts and real API calls.

## Prerequisites
- Kodi addon settings configured (API key, provider, model)
- Python 3 available

## Usage

// turbo-all

### 1. Full game (all correct answers)
```bash
python3 "/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/.agent/tests/test_millionaire_game.py" --scenario all-correct
```

### 2. Game with failure at specific round
```bash
python3 "/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/.agent/tests/test_millionaire_game.py" --scenario fail-at-5
```

### 3. Quick test (fail at round 1 = only 3 inferences)
```bash
python3 "/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/.agent/tests/test_millionaire_game.py" --scenario fail-at-1
```

### 4. Custom media
```bash
python3 "/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/.agent/tests/test_millionaire_game.py" --media "Breaking Bad" --plot "Walter White becomes a meth cook"
```

### 5. With lifeline simulation
```bash
python3 "/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/.agent/tests/test_millionaire_game.py" --use-lifeline "5050:3,tip:5"
```

### 6. With TTS audio playback
```bash
python3 "/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/.agent/tests/test_millionaire_game.py" --scenario fail-at-1 --tts
```

## Parameters

| Parameter | Default | Description |
|-----------|---------|-------------|
| `--scenario` | `all-correct` | `all-correct`, `fail-at-N`, `random` |
| `--media` | `Zaklínač` | Series title |
| `--plot` | (Zaklínač plot) | Plot description |
| `--use-lifeline` | (none) | Format: `type:round,type:round` |
| `--report-dir` | `.agent/tests/reports/` | Report output directory |
| `--tts` | `false` | Enable TTS audio (OpenAI API + afplay, sync) |

## Output
- Live console output with colored progress
- Markdown report saved to `reports/` directory
- Token usage and cost analysis

## What It Tests
- System prompt building with dynamic moderator styles (millionaire_prompts.py + moderator_styles/)
- Welcome inference (JSON: moderator_welcome, rules_summary)
- Question inference (JSON: question, options, correct, explanation, moderator_intro)
- Feedback inference (JSON: result_announcement, transition_text)
- Multi-turn chat history accumulation
- Token usage tracking
- TTS generation and playback (with --tts flag)
