---
description: Generate image for Kodi addon -- icons, backgrounds, fanart, banners
---

# /image

Syntax: see `workflow-syntax.md` -- scope: image type, `/do` = generate without asking

Use skill `kodi-image-generator`.

## Procedure

### 1. Determine Requirements (without `/do`)
- A) Addon icon (256x256, PNG)
- B) Fanart/background (1920x1080, JPG)
- C) Banner (758x140, PNG)
- D) UI graphics (buttons, decorations)
- E) Custom specification

### 2. Clarify Details
- Dimensions and format
- Theme/style (consistent with addon)
- Content and composition

### 3. Generate Image
```
generate_image(Prompt="...", ImageName="...")
```

### 4. Wait for Approval (without `/do`)

### 5. Post-processing (after approval)
- Resize to target dimensions (PIL/Pillow)
- Save to `resources/media/` or addon root folder

## Rules
- No WebP (limited Kodi support)
- Icons must be readable at small size
- Fanart must not contain text (will be covered by UI)
- Transparency only PNG

## Paths in Addon
```
resources/
├── icon.png      # Main icon 256x256
├── fanart.jpg    # Background 1920x1080
└── media/        # Additional graphics
```
