---
description: Create or update feature documentation for completed/in-progress functionality
---

# /feature

Syntax: see `workflow-syntax.md` -- scope: feature name/description, `/do` = create without asking

> [!IMPORTANT]
> **Main goal**: Documentation MUST be self-sufficient enough that a NEW INDEPENDENT AGENT
> without any context can fully understand the feature and immediately:
> modify code, add functionality, change graphics, fix bugs.
>
> **Balance**: Be complete, but save tokens. No filler, no repetition.
> Use references (file paths, line ranges) instead of copying code.

---

## Mode Detection

Three modes -- agent determines automatically:

### 1. AUTO-UPDATE (default, no parameters)
**Trigger**: `/feature` without parameters
**Intent**: User just finished work and wants to update all affected documentation.

**Procedure**:
1. **Determine session context** -- from conversation history, active documents, and recent changes understand WHAT was just done
2. **Search ENTIRE `docs/` directory** (all subdirectories: features, knowledge, issues, audits, research, etc.)
3. **Identify ALL relevant docs** -- every file related to changed files, modified functionality, or affected components
4. **Read each relevant doc** and compare with current codebase state
5. **Update each doc** where content doesn't match reality:
   - File Map -- add/remove/update files
   - Key Interfaces -- update signatures
   - Architecture -- update if data flow changed
   - Dependencies -- update if dependencies changed
   - Add `## Updated: [YYYY-MM-DD HH:mm]`
6. **Summarize** what was updated (list of docs + brief description of changes)

> [!CAUTION]
> Do NOT miss ANY relevant doc. Search ALL subdirectories in `docs/`.
> Not just `docs/features/` -- also check `docs/knowledge/`, `docs/issues/`, etc.

---

### 2. FULL AUDIT (`/feature all`)
**Trigger**: `/feature all`
**Intent**: Complete audit of ALL docs vs. current codebase state.

**Procedure**:
1. **Load list of ALL .md files** in entire `docs/` directory (recursive)
2. **For each doc**:
   a. Read content
   b. Check File Map -- do files exist? Are roles current?
   c. Check Key Interfaces -- do signatures match?
   d. Check Architecture -- does it match current code?
   e. Check Dependencies -- are they current?
   f. Check Status -- is COMPLETED/IN_PROGRESS correct?
3. **Update all docs** where content doesn't match reality
4. **Report** -- table of all docs with result (current / updated / problem)

> [!WARNING]
> This is a resource-intensive operation. May take longer for large projects.
> Every doc MUST be compared against actual code, not just briefly read.

---

### 3. CREATE (new feature doc)
**Trigger**: Agent recognizes from context that user wants to CREATE new documentation
- Input describes a new feature that doesn't have a doc yet
- Explicit mention of "new", "create", "document"
- If unclear whether CREATE or UPDATE -> **ask**

**Procedure**:
1. Ask user (without `/do`):
   - Feature name
   - Status (completed/in-progress)
   - Brief description (1 sentence)
2. Check `docs/features/` for next index
3. Name as `[XXX]-[name].md` (kebab-case)
4. Analyze relevant code thoroughly -- understand architecture, not just surface
5. Create documentation following structure below
6. Self-check: "Could a new agent modify this feature from this doc alone?" If not, add what's missing

---

## Documentation Structure

### Required Sections
1. **Header** -- Name, Status (COMPLETED/IN_PROGRESS/PLANNED), creation/update date
2. **Purpose** -- What the feature does and WHY (1-3 sentences)
3. **Architecture** -- How it works, data flow, key decisions (diagram if complex)
4. **File Map** -- Every relevant file with its role (table):
   | File | Role |
   | --- | --- |
   | `path/to/file.py` | Description |
5. **Key Interfaces** -- Public functions/classes the agent needs to know (signature + 1 line description, NOT full code)
6. **UI Components** -- screens/views, components, templates, assets, layout (if relevant)
7. **Dependencies** -- What this feature depends on and what depends on it
8. **How to Extend** -- Concrete steps for common modifications (add new X, change Y)
9. **TODO** -- Remaining work (only for IN_PROGRESS)

### Rules
- **File links** with line ranges: `[file.py](file:///path#L10-L30)` -- never paste large code blocks
- **Tables over prose** for structured data (files, controls, settings)
- **Max ~300 lines** per feature doc -- if longer, split or shorten
- **No speculation** -- document only what exists
- **No full source code** -- only signatures and references
