---
description: Update docs/README.md - Kodi addon documentation
---

# /docs-readme

Syntax: `/docs-readme` or `/do docs-readme`

Creates `docs/README.md` as documentation for addon users.

THIS IS NOT TECHNICAL DOCUMENTATION:
- No Python code, no API details
- Only what the addon does, not how
- Written for regular Kodi users

## Procedure

### 1. Addon Analysis
Review:
- `addon.xml` -> metadata, dependencies
- Python modules -> user-facing features
- XML layouts -> UI screens
- `resources/` -> graphics, strings

### 2. Feature Extraction
For each feature:
- What it does (user perspective)
- When the user would use it
- What value it provides

### 3. Documentation Structure
- What is [Addon Name]
- Requirements (Kodi version, dependencies)
- Installation
- How to use
- Features (overview)
- Settings
- FAQ
- Known issues

## Rules
- User-friendly language
- Specific usage examples
- Screenshots where helpful
- ALL features covered
- No code
